/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.filter;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.ColumnDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DataRange;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnSlice;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.QueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexExpression;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexOperator;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedFilter {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedFilter.class);
    public final ColumnFamilyStore cfs;
    public final long timestamp;
    public final DataRange dataRange;
    private final int maxResults;
    private final boolean countCQL3Rows;
    private volatile int currentLimit;

    public static ExtendedFilter create(ColumnFamilyStore cfs, DataRange dataRange, List<IndexExpression> clause, int maxResults, boolean countCQL3Rows, long timestamp) {
        if (clause == null || clause.isEmpty()) {
            return new EmptyClauseFilter(cfs, dataRange, maxResults, countCQL3Rows, timestamp);
        }
        return new WithClauses(cfs, dataRange, clause, maxResults, countCQL3Rows, timestamp);
    }

    protected ExtendedFilter(ColumnFamilyStore cfs, DataRange dataRange, int maxResults, boolean countCQL3Rows, long timestamp) {
        assert (cfs != null);
        assert (dataRange != null);
        this.cfs = cfs;
        this.dataRange = dataRange;
        this.maxResults = maxResults;
        this.timestamp = timestamp;
        this.countCQL3Rows = countCQL3Rows;
        this.currentLimit = maxResults;
        if (countCQL3Rows) {
            dataRange.updateColumnsLimit(maxResults);
        }
    }

    public int maxRows() {
        return this.countCQL3Rows ? Integer.MAX_VALUE : this.maxResults;
    }

    public int maxColumns() {
        return this.countCQL3Rows ? this.maxResults : Integer.MAX_VALUE;
    }

    public int currentLimit() {
        return this.currentLimit;
    }

    public IDiskAtomFilter columnFilter(ByteBuffer key) {
        return this.dataRange.columnFilter(key);
    }

    public int lastCounted(ColumnFamily data) {
        return this.dataRange.getLiveCount(data, this.timestamp);
    }

    public void updateFilter(int currentColumnsCount) {
        if (!this.countCQL3Rows) {
            return;
        }
        this.currentLimit = this.maxResults - currentColumnsCount;
        this.dataRange.updateColumnsLimit(this.currentLimit);
    }

    public abstract List<IndexExpression> getClause();

    public abstract IDiskAtomFilter getExtraFilter(DecoratedKey var1, ColumnFamily var2);

    public abstract ColumnFamily prune(DecoratedKey var1, ColumnFamily var2);

    public boolean ignoreTombstonedPartitions() {
        return this.dataRange.ignoredTombstonedPartitions();
    }

    public abstract boolean isSatisfiedBy(DecoratedKey var1, ColumnFamily var2, ColumnNameBuilder var3);

    public static boolean satisfies(int comparison, IndexOperator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("cfs", (Object)this.cfs).add("dataRange", (Object)this.dataRange).add("maxResults", this.maxResults).add("countCQL3Rows", this.countCQL3Rows).add("currentLimit", this.currentLimit).toString();
    }

    private static class EmptyClauseFilter
    extends ExtendedFilter {
        public EmptyClauseFilter(ColumnFamilyStore cfs, DataRange range, int maxResults, boolean countCQL3Rows, long timestamp) {
            super(cfs, range, maxResults, countCQL3Rows, timestamp);
        }

        @Override
        public List<IndexExpression> getClause() {
            return Collections.emptyList();
        }

        @Override
        public IDiskAtomFilter getExtraFilter(DecoratedKey key, ColumnFamily data) {
            return null;
        }

        @Override
        public ColumnFamily prune(DecoratedKey rowKey, ColumnFamily data) {
            return data;
        }

        @Override
        public boolean isSatisfiedBy(DecoratedKey rowKey, ColumnFamily data, ColumnNameBuilder builder) {
            return true;
        }
    }

    public static class WithClauses
    extends ExtendedFilter {
        private final List<IndexExpression> clause;
        private final IDiskAtomFilter optimizedFilter;

        public WithClauses(ColumnFamilyStore cfs, DataRange range, List<IndexExpression> clause, int maxResults, boolean countCQL3Rows, long timestamp) {
            super(cfs, range, maxResults, countCQL3Rows, timestamp);
            assert (clause != null);
            this.clause = clause;
            this.optimizedFilter = this.computeOptimizedFilter();
        }

        private IDiskAtomFilter computeOptimizedFilter() {
            if (this.cfs.getComparator() instanceof CompositeType || this.dataRange instanceof DataRange.Paging) {
                return null;
            }
            IDiskAtomFilter filter = this.dataRange.columnFilter(null);
            if (filter instanceof SliceQueryFilter) {
                if (this.cfs.getMaxRowSize() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                    logger.trace("Expanding slice filter to entire row to cover additional expressions");
                    return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, ((SliceQueryFilter)filter).reversed, Integer.MAX_VALUE);
                }
            } else {
                logger.trace("adding columns to original Filter to cover additional expressions");
                assert (filter instanceof NamesQueryFilter);
                if (!this.clause.isEmpty()) {
                    TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
                    for (IndexExpression expr : this.clause) {
                        columns.add(expr.column_name);
                    }
                    columns.addAll(((NamesQueryFilter)filter).columns);
                    return ((NamesQueryFilter)filter).withUpdatedColumns(columns);
                }
            }
            return null;
        }

        @Override
        public IDiskAtomFilter columnFilter(ByteBuffer key) {
            return this.optimizedFilter == null ? this.dataRange.columnFilter(key) : this.optimizedFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            return this.clause;
        }

        private boolean needsExtraQuery(ByteBuffer rowKey, ColumnFamily data) {
            IDiskAtomFilter filter = this.columnFilter(rowKey);
            if (filter instanceof SliceQueryFilter && DataRange.isFullRowSlice((SliceQueryFilter)filter)) {
                return false;
            }
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                logger.debug("adding extraFilter to cover additional expressions");
                return true;
            }
            return false;
        }

        @Override
        public IDiskAtomFilter getExtraFilter(DecoratedKey rowKey, ColumnFamily data) {
            assert (!(this.cfs.getComparator() instanceof CompositeType)) : "Sequential scan with filters is not supported (if you just created an index, you need to wait for the creation to be propagated to all nodes before querying it)";
            if (!this.needsExtraQuery(rowKey.key, data)) {
                return null;
            }
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                columns.add(expr.column_name);
            }
            assert (!columns.isEmpty());
            return new NamesQueryFilter(columns);
        }

        @Override
        public ColumnFamily prune(DecoratedKey rowKey, ColumnFamily data) {
            if (this.optimizedFilter == null) {
                return data;
            }
            ColumnFamily pruned = data.cloneMeShallow();
            IDiskAtomFilter filter = this.dataRange.columnFilter(rowKey.key);
            OnDiskAtomIterator iter = filter.getColumnFamilyIterator(rowKey, data);
            filter.collectReducedColumns(pruned, QueryFilter.gatherTombstones(pruned, iter), this.cfs.gcBefore(this.timestamp), this.timestamp);
            return pruned;
        }

        @Override
        public boolean isSatisfiedBy(DecoratedKey rowKey, ColumnFamily data, ColumnNameBuilder builder) {
            for (IndexExpression expression : this.clause) {
                ColumnDefinition def = data.metadata().getColumnDefinition(expression.column_name);
                ByteBuffer dataValue = null;
                AbstractType<?> validator = null;
                if (def == null) {
                    Column column = data.getColumn(expression.column_name);
                    if (column != null) {
                        dataValue = column.value();
                        validator = data.metadata().getDefaultValidator();
                    }
                } else {
                    dataValue = this.extractDataValue(def, rowKey.key, data, builder);
                    validator = def.getValidator();
                }
                if (dataValue == null) {
                    return false;
                }
                int v = validator.compare(dataValue, expression.value);
                if (WithClauses.satisfies(v, expression.op)) continue;
                return false;
            }
            return true;
        }

        private ByteBuffer extractDataValue(ColumnDefinition def, ByteBuffer rowKey, ColumnFamily data, ColumnNameBuilder builder) {
            switch (def.type) {
                case PARTITION_KEY: {
                    return def.componentIndex == null ? rowKey : ((CompositeType)data.metadata().getKeyValidator()).split(rowKey)[def.componentIndex];
                }
                case CLUSTERING_KEY: {
                    return builder.get(def.componentIndex);
                }
                case REGULAR: {
                    ByteBuffer colName = builder == null ? def.name : builder.copy().add(def.name).build();
                    Column column = data.getColumn(colName);
                    return column == null ? null : column.value();
                }
                case COMPACT_VALUE: {
                    assert (data.getColumnCount() == 1);
                    return data.getSortedColumns().iterator().next().value();
                }
            }
            throw new AssertionError();
        }
    }
}

