/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TreeMapBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnSlice;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ExtendedFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.QueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexSearcher;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexExpression;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositesSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(CompositesSearcher.class);

    public CompositesSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    @Override
    public List<Row> search(ExtendedFilter filter) {
        assert (filter.getClause() != null && !filter.getClause().isEmpty());
        return this.baseCfs.filter(this.getIndexedIterator(filter), filter);
    }

    private ByteBuffer makePrefix(CompositesIndex index, ByteBuffer key, ExtendedFilter filter, boolean isStart) {
        ColumnNameBuilder builder;
        if (key.remaining() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        IDiskAtomFilter columnFilter = filter.columnFilter(key);
        if (columnFilter instanceof SliceQueryFilter) {
            SliceQueryFilter sqf = (SliceQueryFilter)columnFilter;
            builder = index.makeIndexColumnNameBuilder(key, isStart ? sqf.start() : sqf.finish());
        } else {
            builder = index.getIndexComparator().builder().add(key);
        }
        return isStart ? builder.build() : builder.buildAsEndOfRange();
    }

    private ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final ExtendedFilter filter) {
        final IndexExpression primary = this.highestSelectivityPredicate(filter.getClause());
        final CompositesIndex index = (CompositesIndex)this.indexManager.getIndexForColumn(primary.column_name);
        assert (index != null);
        assert (index.getIndexCfs() != null);
        final DecoratedKey indexKey = index.getIndexKeyFor(primary.value);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)index.expressionString(primary));
        }
        final AbstractBounds<RowPosition> range = filter.dataRange.keyRange();
        ByteBuffer startKey = range.left instanceof DecoratedKey ? ((DecoratedKey)range.left).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        ByteBuffer endKey = range.right instanceof DecoratedKey ? ((DecoratedKey)range.right).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        final CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        final CompositeType indexComparator = (CompositeType)index.getIndexCfs().getComparator();
        final ByteBuffer startPrefix = this.makePrefix(index, startKey, filter, true);
        final ByteBuffer endPrefix = this.makePrefix(index, endKey, filter, false);
        return new ColumnFamilyStore.AbstractScanIterator(){
            private ByteBuffer lastSeenPrefix;
            private Deque<Column> indexColumns;
            private int columnsRead;
            private int limit;
            private int columnsCount;
            private int indexCellsPerQuery;
            {
                this.lastSeenPrefix = startPrefix;
                this.columnsRead = Integer.MAX_VALUE;
                this.limit = filter.currentLimit();
                this.columnsCount = 0;
                this.indexCellsPerQuery = Math.max(2, Math.min(filter.maxColumns(), filter.maxRows()));
            }

            @Override
            public boolean needsFiltering() {
                return false;
            }

            private Row makeReturn(DecoratedKey key, ColumnFamily data) {
                if (data == null) {
                    return (Row)this.endOfData();
                }
                assert (key != null);
                return new Row(key, data);
            }

            protected Row computeNext() {
                DecoratedKey currentKey = null;
                ColumnFamily data = null;
                block0: while (this.columnsCount < this.limit) {
                    if (this.indexColumns == null || this.indexColumns.isEmpty()) {
                        if (this.columnsRead < this.indexCellsPerQuery) {
                            logger.trace("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)this.indexCellsPerQuery);
                            return this.makeReturn(currentKey, data);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Scanning index {} starting with {}", (Object)index.expressionString(primary), (Object)indexComparator.getString(startPrefix));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, index.getIndexCfs().name, this.lastSeenPrefix, endPrefix, false, this.indexCellsPerQuery, filter.timestamp);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        if (indexRow == null || indexRow.getColumnCount() == 0) {
                            return this.makeReturn(currentKey, data);
                        }
                        Collection<Column> sortedColumns = indexRow.getSortedColumns();
                        this.columnsRead = sortedColumns.size();
                        this.indexColumns = new ArrayDeque<Column>(sortedColumns);
                        Column firstColumn = sortedColumns.iterator().next();
                        if (this.lastSeenPrefix != startPrefix && this.lastSeenPrefix.equals(firstColumn.name())) {
                            this.indexColumns.poll();
                            logger.trace("Skipping {}", (Object)indexComparator.getString(firstColumn.name()));
                        }
                    }
                    while (true) {
                        ColumnSlice[] slices;
                        if (this.indexColumns.isEmpty() || this.columnsCount > this.limit) continue block0;
                        Column column = this.indexColumns.poll();
                        this.lastSeenPrefix = column.name();
                        if (column.isMarkedForDelete(filter.timestamp)) {
                            logger.trace("skipping {}", (Object)column.name());
                            continue;
                        }
                        CompositesIndex.IndexedEntry entry = index.decodeEntry(indexKey, column);
                        DecoratedKey dk = ((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner.decorateKey(entry.indexedKey);
                        if (currentKey == null) {
                            currentKey = dk;
                        } else if (!currentKey.equals(dk)) {
                            DecoratedKey previousKey = currentKey;
                            currentKey = dk;
                            this.indexColumns.addFirst(column);
                            if (data == null) continue;
                            return this.makeReturn(previousKey, data);
                        }
                        if (!range.contains(dk)) {
                            if (!((RowPosition)range.right).isMinimum(((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                                logger.trace("Reached end of assigned scan range");
                                return (Row)this.endOfData();
                            }
                            logger.debug("Skipping entry {} before assigned scan range", (Object)dk.token);
                            continue;
                        }
                        ByteBuffer start = entry.indexedEntryStart();
                        if (!filter.columnFilter(dk.key).maySelectPrefix(baseComparator, start)) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Adding index hit to current row for {}", (Object)indexComparator.getString(column.name()));
                        }
                        ColumnSlice dataSlice = new ColumnSlice(start, entry.indexedEntryEnd());
                        if (((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata.hasStaticColumns()) {
                            ColumnSlice staticSlice = new ColumnSlice(ByteBufferUtil.EMPTY_BYTE_BUFFER, ((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata.getStaticColumnNameBuilder().buildAsEndOfRange());
                            slices = new ColumnSlice[]{staticSlice, dataSlice};
                        } else {
                            slices = new ColumnSlice[]{dataSlice};
                        }
                        SliceQueryFilter dataFilter = new SliceQueryFilter(slices, false, Integer.MAX_VALUE, ((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata.clusteringKeyColumns().size());
                        ColumnFamily newData = CompositesSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((CompositesSearcher)CompositesSearcher.this).baseCfs.name, dataFilter, filter.timestamp));
                        if (newData == null || index.isStale(entry, newData, filter.timestamp)) {
                            index.delete(entry);
                            continue;
                        }
                        assert (newData != null) : "An entry with not data should have been considered stale";
                        if (!filter.isSatisfiedBy(dk, newData, entry.indexedEntryNameBuilder)) continue;
                        if (data == null) {
                            data = TreeMapBackedSortedColumns.factory.create(((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata);
                        }
                        data.resolve(newData);
                        this.columnsCount += dataFilter.lastCounted();
                    }
                    break;
                }
                return this.makeReturn(currentKey, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

