/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BytesType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.AsciiSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class AsciiType
extends AbstractType<String> {
    public static final AsciiType instance = new AsciiType();
    private final ThreadLocal<CharsetEncoder> encoder = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("US-ASCII").newEncoder();
        }
    };

    AsciiType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) {
        CharsetEncoder theEncoder = this.encoder.get();
        theEncoder.reset();
        try {
            return theEncoder.encode(CharBuffer.wrap(source));
        }
        catch (CharacterCodingException exc) {
            throw new MarshalException(String.format("Invalid ASCII character in string literal: %s", exc));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.ASCII;
    }

    @Override
    public TypeSerializer<String> getSerializer() {
        return AsciiSerializer.instance;
    }
}

