/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public class RepairJobDesc {
    public static final IVersionedSerializer<RepairJobDesc> serializer = new RepairJobDescSerializer();
    public final UUID sessionId;
    public final String keyspace;
    public final String columnFamily;
    public final Range<Token> range;

    public RepairJobDesc(UUID sessionId, String keyspace, String columnFamily, Range<Token> range) {
        this.sessionId = sessionId;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.range = range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[repair #");
        sb.append(this.sessionId);
        sb.append(" on ");
        sb.append(this.keyspace).append("/").append(this.columnFamily);
        sb.append(", ").append(this.range);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairJobDesc that = (RepairJobDesc)o;
        if (!this.columnFamily.equals(that.columnFamily)) {
            return false;
        }
        if (!this.keyspace.equals(that.keyspace)) {
            return false;
        }
        if (this.range != null ? !this.range.equals(that.range) : that.range != null) {
            return false;
        }
        return this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sessionId, this.keyspace, this.columnFamily, this.range});
    }

    private static class RepairJobDescSerializer
    implements IVersionedSerializer<RepairJobDesc> {
        private RepairJobDescSerializer() {
        }

        @Override
        public void serialize(RepairJobDesc desc, DataOutput out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(desc.sessionId, out, version);
            out.writeUTF(desc.keyspace);
            out.writeUTF(desc.columnFamily);
            AbstractBounds.serializer.serialize((AbstractBounds<?>)desc.range, out, version);
        }

        @Override
        public RepairJobDesc deserialize(DataInput in, int version) throws IOException {
            UUID sessionId = UUIDSerializer.serializer.deserialize(in, version);
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            Range range = (Range)AbstractBounds.serializer.deserialize(in, version);
            return new RepairJobDesc(sessionId, keyspace, columnFamily, range);
        }

        @Override
        public long serializedSize(RepairJobDesc desc, int version) {
            int size = 0;
            size = (int)((long)size + UUIDSerializer.serializer.serializedSize(desc.sessionId, version));
            size += TypeSizes.NATIVE.sizeof(desc.keyspace);
            size += TypeSizes.NATIVE.sizeof(desc.columnFamily);
            size = (int)((long)size + AbstractBounds.serializer.serializedSize((AbstractBounds<?>)desc.range, version));
            return size;
        }
    }
}

