/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.FailureDetector;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BatchlogEndpointSelector {
    private final String localRack;

    public BatchlogEndpointSelector(String localRack) {
        this.localRack = localRack;
    }

    public Collection<InetAddress> chooseEndpoints(Multimap<String, InetAddress> endpoints) {
        Collection racks;
        ArrayListMultimap validated = ArrayListMultimap.create();
        for (Map.Entry entry : endpoints.entries()) {
            if (!this.isValid((InetAddress)entry.getValue())) continue;
            validated.put(entry.getKey(), entry.getValue());
        }
        if (validated.size() <= 2) {
            return validated.values();
        }
        if (validated.size() - validated.get((Object)this.localRack).size() >= 2) {
            validated.removeAll((Object)this.localRack);
        }
        if (validated.keySet().size() == 1) {
            Collection otherRack = (Collection)Iterables.getOnlyElement(validated.asMap().values());
            return Lists.newArrayList((Iterable)Iterables.limit((Iterable)otherRack, (int)2));
        }
        if (validated.keySet().size() == 2) {
            racks = validated.keySet();
        } else {
            racks = Lists.newArrayList((Iterable)validated.keySet());
            Collections.shuffle((List)racks);
        }
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(2);
        for (String rack : Iterables.limit((Iterable)racks, (int)2)) {
            List rackMembers = validated.get((Object)rack);
            result.add((InetAddress)rackMembers.get(this.getRandomInt(rackMembers.size())));
        }
        return result;
    }

    @VisibleForTesting
    protected boolean isValid(InetAddress input) {
        return !input.equals(FBUtilities.getBroadcastAddress()) && FailureDetector.instance.isAlive(input);
    }

    @VisibleForTesting
    protected int getRandomInt(int bound) {
        return FBUtilities.threadLocalRandom().nextInt(bound);
    }
}

