/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress;

import com.google.common.base.Throwables;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableWriter;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.ProgressInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress.CompressedInputStream;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress.CompressionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.FileMessageHeader;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.BytesReadTracker;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class CompressedStreamReader
extends StreamReader {
    protected final CompressionInfo compressionInfo;

    public CompressedStreamReader(FileMessageHeader header, StreamSession session) {
        super(header, session);
        this.compressionInfo = header.compressionInfo;
    }

    @Override
    public SSTableWriter read(ReadableByteChannel channel) throws IOException {
        long totalSize = this.totalSize();
        Pair<String, String> kscf = Schema.instance.getCF(this.cfId);
        if (kscf == null) {
            throw new IOException("CF " + this.cfId + " was dropped during streaming");
        }
        ColumnFamilyStore cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
        SSTableWriter writer = this.createWriter(cfs, totalSize);
        CompressedInputStream cis = new CompressedInputStream(Channels.newInputStream(channel), this.compressionInfo, this.inputVersion.hasPostCompressionAdlerChecksums);
        BytesReadTracker in = new BytesReadTracker(new DataInputStream(cis));
        try {
            for (Pair section : this.sections) {
                long length = (Long)section.right - (Long)section.left;
                cis.position((Long)section.left);
                in.reset(0L);
                while (in.getBytesRead() < length) {
                    this.writeRow(writer, in, cfs);
                    this.session.progress(this.desc, ProgressInfo.Direction.IN, cis.getTotalCompressedBytesRead(), totalSize);
                }
            }
            return writer;
        }
        catch (Throwable e) {
            writer.abort();
            this.drain(cis, in.getBytesRead());
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }
}

