/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils.vint;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.AbstractDataInput;
import java.io.DataInput;
import java.io.IOException;

public class EncodedDataInputStream
extends AbstractDataInput {
    private DataInput input;

    public EncodedDataInputStream(DataInput input) {
        this.input = input;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.input.skipBytes(n);
    }

    @Override
    public int read() throws IOException {
        return this.input.readByte() & 0xFF;
    }

    @Override
    protected void seekInternal(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int getPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.vintDecode();
    }

    @Override
    public long readLong() throws IOException {
        return this.vintDecode();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (short)this.vintDecode();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.vintDecode();
    }

    private long vintDecode() throws IOException {
        byte firstByte = this.input.readByte();
        int len = this.vintDecodeSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = this.input.readByte();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return this.vintIsNegative(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    private int vintDecodeSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    private boolean vintIsNegative(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }
}

