/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.functions;

import com.google.common.base.Function;
import com.netflix.astyanax.model.Row;
import java.util.concurrent.atomic.AtomicLong;

public class ColumnCounterFunction<K, C>
implements Function<Row<K, C>, Boolean> {
    private final AtomicLong counter = new AtomicLong(0L);

    public Boolean apply(Row<K, C> input) {
        this.counter.addAndGet(input.getColumns().size());
        return true;
    }

    public long getCount() {
        return this.counter.get();
    }

    public void reset() {
        this.counter.set(0L);
    }
}

