/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.type.AtlasType;

public interface AtlasFormatConverter {
    public boolean isValidValueV1(Object var1, AtlasType var2);

    public Object fromV1ToV2(Object var1, AtlasType var2, ConverterContext var3) throws AtlasBaseException;

    public Object fromV2ToV1(Object var1, AtlasType var2, ConverterContext var3) throws AtlasBaseException;

    public TypeCategory getTypeCategory();

    public static class ConverterContext {
        private AtlasEntity.AtlasEntitiesWithExtInfo entities = null;

        public void addEntity(AtlasEntity entity) {
            if (this.entities == null) {
                this.entities = new AtlasEntity.AtlasEntitiesWithExtInfo();
            }
            this.entities.addEntity(entity);
        }

        public void addReferredEntity(AtlasEntity entity) {
            if (this.entities == null) {
                this.entities = new AtlasEntity.AtlasEntitiesWithExtInfo();
            }
            this.entities.addReferredEntity(entity);
        }

        public AtlasEntity getById(String guid) {
            if (this.entities != null) {
                return this.entities.getEntity(guid);
            }
            return null;
        }

        public boolean entityExists(String guid) {
            return this.entities != null && this.entities.hasEntity(guid);
        }

        public AtlasEntity.AtlasEntitiesWithExtInfo getEntities() {
            if (this.entities != null) {
                this.entities.compact();
            }
            return this.entities;
        }
    }
}

