/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.impexp.AtlasServerService;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AuditsWriter.class);
    private static final String CLUSTER_NAME_DEFAULT = "default";
    private static final String DC_SERVER_NAME_SEPARATOR = "$";
    private AtlasTypeRegistry typeRegistry;
    private AtlasEntityStore entityStore;
    private AtlasServerService atlasServerService;
    private ExportImportAuditService auditService;
    private ExportAudits auditForExport = new ExportAudits();
    private ImportAudits auditForImport = new ImportAudits();

    @Inject
    public AuditsWriter(AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore, AtlasServerService atlasServerService, ExportImportAuditService auditService) {
        this.typeRegistry = typeRegistry;
        this.entityStore = entityStore;
        this.atlasServerService = atlasServerService;
        this.auditService = auditService;
    }

    public AtlasServerService getAtlasServerService() {
        return this.atlasServerService;
    }

    public void write(String userName, AtlasExportResult result, long startTime, long endTime, List<String> entityCreationOrder) throws AtlasBaseException {
        this.auditForExport.add(userName, result, startTime, endTime, entityCreationOrder);
    }

    public void write(String userName, AtlasImportResult result, long startTime, long endTime, List<String> entityCreationOrder) throws AtlasBaseException {
        this.auditForImport.add(userName, result, startTime, endTime, entityCreationOrder);
    }

    public void write(String userName, String sourceCluster, long startTime, long endTime, Set<String> entityCreationOrder) throws AtlasBaseException {
        this.auditForImport.add(userName, sourceCluster, startTime, endTime, entityCreationOrder);
    }

    private void updateReplicationAttribute(boolean isReplicationSet, String serverName, String serverFullName, List<String> exportedGuids, String attrNameReplicated, long lastModifiedTimestamp) throws AtlasBaseException {
        if (!isReplicationSet || CollectionUtils.isEmpty(exportedGuids)) {
            return;
        }
        String candidateGuid = exportedGuids.get(0);
        String replGuidKey = ReplKeyGuidFinder.get(this.typeRegistry, this.entityStore, candidateGuid);
        AtlasServer server = this.saveServer(serverName, serverFullName, replGuidKey, lastModifiedTimestamp);
        this.atlasServerService.updateEntitiesWithServer(server, exportedGuids, attrNameReplicated);
    }

    private AtlasServer saveServer(String clusterName, String serverFullName, String entityGuid, long lastModifiedTimestamp) throws AtlasBaseException {
        AtlasServer server = this.atlasServerService.getCreateAtlasServer(clusterName, serverFullName);
        server.setAdditionalInfoRepl(entityGuid, lastModifiedTimestamp);
        if (LOG.isDebugEnabled()) {
            LOG.debug("saveServer: {}", (Object)server);
        }
        return this.atlasServerService.save(server);
    }

    public static String getCurrentClusterName() {
        String ret = "";
        try {
            ret = ApplicationProperties.get().getString("atlas.metadata.namespace", "");
            if (StringUtils.isEmpty((String)ret)) {
                ret = ApplicationProperties.get().getString("atlas.cluster.name", CLUSTER_NAME_DEFAULT);
            }
        }
        catch (AtlasException e) {
            LOG.error("getCurrentClusterName", (Throwable)e);
        }
        return ret;
    }

    static String getServerNameFromFullName(String fullName) {
        if (StringUtils.isEmpty((String)fullName) || !fullName.contains(DC_SERVER_NAME_SEPARATOR)) {
            return fullName;
        }
        String[] splits = StringUtils.split((String)fullName, (String)DC_SERVER_NAME_SEPARATOR);
        if (splits == null || splits.length < 1) {
            return "";
        }
        if (splits.length >= 2) {
            return splits[1];
        }
        return splits[0];
    }

    private void saveCurrentServer() throws AtlasBaseException {
        this.atlasServerService.getCreateAtlasServer(AuditsWriter.getCurrentClusterName(), AuditsWriter.getCurrentClusterName());
    }

    private class ImportAudits {
        private AtlasImportRequest request;
        private boolean replicationOptionState;
        private String sourceServerName;
        private String sourceServerFullName;

        private ImportAudits() {
        }

        public void add(String userName, AtlasImportResult result, long startTime, long endTime, List<String> entityGuids) throws AtlasBaseException {
            this.request = result.getRequest();
            this.replicationOptionState = this.request.isReplicationOptionSet();
            AuditsWriter.this.saveCurrentServer();
            this.sourceServerFullName = this.request.getOptionKeyReplicatedFrom();
            this.sourceServerName = AuditsWriter.getServerNameFromFullName(this.sourceServerFullName);
            AuditsWriter.this.auditService.add(userName, this.sourceServerName, AuditsWriter.getCurrentClusterName(), "IMPORT", AtlasType.toJson((Object)result), startTime, endTime, !entityGuids.isEmpty());
            if (result.getOperationStatus() == AtlasImportResult.OperationStatus.FAIL) {
                return;
            }
            AuditsWriter.this.updateReplicationAttribute(this.replicationOptionState, this.sourceServerName, this.sourceServerFullName, entityGuids, "replicatedFrom", result.getExportResult().getChangeMarker());
        }

        public void add(String userName, String sourceCluster, long startTime, long endTime, Set<String> entityGuids) throws AtlasBaseException {
            this.sourceServerName = AuditsWriter.getServerNameFromFullName(sourceCluster);
            AuditsWriter.this.auditService.add(userName, this.sourceServerName, AuditsWriter.getCurrentClusterName(), "IMPORT_DELETE_REPL", AtlasType.toJson(entityGuids), startTime, endTime, !entityGuids.isEmpty());
        }
    }

    private class ExportAudits {
        private AtlasExportRequest request;
        private String targetServerName;
        private boolean replicationOptionState;
        private String targetServerFullName;

        private ExportAudits() {
        }

        public void add(String userName, AtlasExportResult result, long startTime, long endTime, List<String> entityGuids) throws AtlasBaseException {
            this.request = result.getRequest();
            this.replicationOptionState = this.request.isReplicationOptionSet();
            AuditsWriter.this.saveCurrentServer();
            this.targetServerFullName = this.request.getOptionKeyReplicatedTo();
            this.targetServerName = AuditsWriter.getServerNameFromFullName(this.targetServerFullName);
            AuditsWriter.this.auditService.add(userName, AuditsWriter.getCurrentClusterName(), this.targetServerName, "EXPORT", AtlasType.toJson((Object)result), startTime, endTime, !entityGuids.isEmpty());
            if (result.getOperationStatus() == AtlasExportResult.OperationStatus.FAIL) {
                return;
            }
            AuditsWriter.this.updateReplicationAttribute(this.replicationOptionState, this.targetServerName, this.targetServerFullName, entityGuids, "replicatedTo", result.getChangeMarker());
        }
    }

    static class ReplKeyGuidFinder {
        private static final String ENTITY_TYPE_HIVE_DB = "hive_db";
        private static final String ENTITY_TYPE_HIVE_TABLE = "hive_table";
        private static final String ENTITY_TYPE_HIVE_COLUMN = "hive_column";

        ReplKeyGuidFinder() {
        }

        public static String get(AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore, String candidateGuid) {
            String guid = null;
            try {
                guid = ReplKeyGuidFinder.getParentEntityGuid(typeRegistry, entityStore, candidateGuid);
            }
            catch (AtlasBaseException e) {
                LOG.error("Error fetching parent guid for child entity: {}", (Object)candidateGuid);
            }
            if (StringUtils.isEmpty((String)guid)) {
                guid = candidateGuid;
            }
            return guid;
        }

        private static String getParentEntityGuid(AtlasTypeRegistry typeRegistry, AtlasEntityStore entityStore, String defaultGuid) throws AtlasBaseException {
            AtlasEntity.AtlasEntityWithExtInfo extInfo = entityStore.getById(defaultGuid);
            if (extInfo == null || extInfo.getEntity() == null) {
                return null;
            }
            String typeName = extInfo.getEntity().getTypeName();
            if (!typeName.equals(ENTITY_TYPE_HIVE_TABLE) && !typeName.equals(ENTITY_TYPE_HIVE_COLUMN)) {
                return null;
            }
            String hiveDBQualifiedName = ReplKeyGuidFinder.extractHiveDBQualifiedName((String)extInfo.getEntity().getAttribute("qualifiedName"));
            AtlasEntityType entityType = typeRegistry.getEntityTypeByName(ENTITY_TYPE_HIVE_DB);
            return entityStore.getGuidByUniqueAttributes(entityType, Collections.singletonMap("qualifiedName", hiveDBQualifiedName));
        }

        @VisibleForTesting
        static String extractHiveDBQualifiedName(String qualifiedName) {
            return String.format("%s@%s", StringUtils.substringBefore((String)qualifiedName, (String)"."), StringUtils.substringAfter((String)qualifiedName, (String)"@"));
        }
    }
}

