/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ZipExportFileNames;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSourceDirect
implements EntityImportStream {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSourceDirect.class);
    private static final String ZIP_ENTRY_ENTITIES = "entities.json";
    private final ZipInputStream zipInputStream;
    private int currentPosition;
    private ImportTransforms importTransform;
    private List<BaseEntityHandler> entityHandlers;
    private AtlasTypesDef typesDef;
    private int streamSize = 1;
    EntitiesArrayParser entitiesArrayParser;

    public ZipSourceDirect(InputStream inputStream, int streamSize) throws IOException, AtlasBaseException {
        this.zipInputStream = new ZipInputStream(inputStream);
        this.streamSize = streamSize;
        this.prepareStreamForFetch();
        if (this.streamSize == 1) {
            LOG.info("ZipSourceDirect: Stream Size set to: {}. This will cause inaccurate percentage reporting.", (Object)this.streamSize);
        }
    }

    @Override
    public ImportTransforms getImportTransform() {
        return this.importTransform;
    }

    @Override
    public void setImportTransform(ImportTransforms importTransform) {
        this.importTransform = importTransform;
    }

    @Override
    public List<BaseEntityHandler> getEntityHandlers() {
        return this.entityHandlers;
    }

    @Override
    public void setEntityHandlers(List<BaseEntityHandler> entityHandlers) {
        this.entityHandlers = entityHandlers;
    }

    @Override
    public AtlasTypesDef getTypesDef() throws AtlasBaseException {
        return this.typesDef;
    }

    @Override
    public AtlasExportResult getExportResult() throws AtlasBaseException {
        return new AtlasExportResult();
    }

    @Override
    public List<String> getCreationOrder() {
        return new ArrayList<String>();
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getEntityWithExtInfo(String json) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.convertFromJson(AtlasEntity.AtlasEntityWithExtInfo.class, json);
        if (this.importTransform != null) {
            entityWithExtInfo = this.importTransform.apply(entityWithExtInfo);
        }
        if (this.entityHandlers != null) {
            this.applyTransformers(entityWithExtInfo);
        }
        return entityWithExtInfo;
    }

    @Override
    public boolean hasNext() {
        return this.entitiesArrayParser != null && this.entitiesArrayParser.hasNext();
    }

    @Override
    public AtlasEntity next() {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getNextEntityWithExtInfo();
        return entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getNextEntityWithExtInfo() {
        try {
            if (this.hasNext()) {
                String json = this.moveNext();
                return this.getEntityWithExtInfo(json);
            }
        }
        catch (AtlasBaseException e) {
            LOG.error("getNextEntityWithExtInfo", (Throwable)e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }

    @Override
    public AtlasEntity getByGuid(String guid) {
        try {
            return this.getEntity(guid);
        }
        catch (AtlasBaseException e) {
            LOG.error("getByGuid: {} failed!", (Object)guid, (Object)e);
            return null;
        }
    }

    @Override
    public void onImportComplete(String guid) {
    }

    @Override
    public void setPosition(int index) {
        for (int i = 0; i < index; ++i) {
            this.moveNext();
        }
    }

    @Override
    public void setPositionUsingEntityGuid(String guid) {
    }

    @Override
    public void close() {
        if (this.entitiesArrayParser != null) {
            this.entitiesArrayParser.close();
        }
    }

    private void applyTransformers(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (entityWithExtInfo == null) {
            return;
        }
        this.transform(entityWithExtInfo.getEntity());
        if (MapUtils.isNotEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.transform(e);
            }
        }
    }

    private void transform(AtlasEntity e) {
        for (BaseEntityHandler handler : this.entityHandlers) {
            handler.transform(e);
        }
    }

    private <T> T convertFromJson(Class<T> clazz, String jsonData) throws AtlasBaseException {
        try {
            return (T)AtlasType.fromJson((String)jsonData, clazz);
        }
        catch (Exception e) {
            throw new AtlasBaseException("Error converting file to JSON.", (Throwable)e);
        }
    }

    private AtlasEntity getEntity(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo extInfo = this.getEntityWithExtInfo(guid);
        return extInfo != null ? extInfo.getEntity() : null;
    }

    @Override
    public int size() {
        if (this.streamSize == 1) {
            return this.currentPosition;
        }
        return this.streamSize;
    }

    private String moveNext() {
        try {
            this.moveNextEntry();
            return this.entitiesArrayParser.next();
        }
        catch (IOException e) {
            LOG.error("moveNext failed!", (Throwable)e);
            return null;
        }
    }

    private void moveNextEntry() throws IOException {
        ++this.currentPosition;
    }

    private void prepareStreamForFetch() throws AtlasBaseException, IOException {
        ZipEntry zipEntryNext = this.zipInputStream.getNextEntry();
        if (zipEntryNext == null) {
            throw new AtlasBaseException(AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP, new String[]{"Attempting to import empty ZIP."});
        }
        if (zipEntryNext.getName().equals(ZipExportFileNames.ATLAS_TYPESDEF_NAME.toEntryFileName())) {
            String json = this.getJsonPayloadFromZipEntryStream(this.zipInputStream);
            this.typesDef = (AtlasTypesDef)AtlasType.fromJson((String)json, AtlasTypesDef.class);
        }
        if (!(zipEntryNext = this.zipInputStream.getNextEntry()).getName().equals(ZIP_ENTRY_ENTITIES)) {
            throw new AtlasBaseException(AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP, new String[]{"Attempting to import empty ZIP. entities.json could not be found!"});
        }
        this.entitiesArrayParser = new EntitiesArrayParser(this.zipInputStream);
    }

    private String getJsonPayloadFromZipEntryStream(ZipInputStream zipInputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)bos);
        }
        catch (IOException e) {
            LOG.error("Streaming copying failed!", (Throwable)e);
            return null;
        }
        return bos.toString();
    }

    static class EntitiesArrayParser {
        private static final String EMPTY_OBJECT = "{}";
        private final JsonFactory factory = AtlasJson.getMapper().getFactory();
        private final JsonParser parser;
        private boolean hasNext;

        public EntitiesArrayParser(InputStream inputStream) throws IOException {
            this.parser = this.factory.createParser(inputStream);
            this.parseNext();
        }

        public String next() throws IOException {
            JsonToken jsonToken = this.parseNext();
            if (!this.hasNext) {
                return null;
            }
            if (jsonToken != null && jsonToken == JsonToken.START_OBJECT) {
                JsonNode node = (JsonNode)this.parser.readValueAsTree();
                return this.validate(node.toString());
            }
            return null;
        }

        private JsonToken parseNext() throws IOException {
            JsonToken jsonToken = this.parser.nextToken();
            this.hasNext = jsonToken != null && jsonToken != JsonToken.END_ARRAY;
            return jsonToken;
        }

        private String validate(String payload) {
            if (payload.equals(EMPTY_OBJECT)) {
                this.hasNext = false;
                this.close();
                return null;
            }
            return payload;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public void close() {
            try {
                this.parser.close();
            }
            catch (IOException e) {
                LOG.error("Error closing parser!", (Throwable)e);
            }
        }
    }
}

