/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.ClassificationTextPatch;
import org.apache.atlas.repository.patches.FreeTextRequestHandlerPatch;
import org.apache.atlas.repository.patches.IndexConsistencyPatch;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.repository.patches.ProcessNamePatch;
import org.apache.atlas.repository.patches.ReIndexPatch;
import org.apache.atlas.repository.patches.SuggestionsRequestHandlerPatch;
import org.apache.atlas.repository.patches.UniqueAttributePatch;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasPatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPatchManager.class);
    private final PatchContext context;
    private final List<AtlasPatchHandler> handlers = new ArrayList<AtlasPatchHandler>();

    @Inject
    public AtlasPatchManager(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, GraphBackedSearchIndexer indexer, EntityGraphMapper entityGraphMapper) {
        this.context = new PatchContext(atlasGraph, typeRegistry, indexer, entityGraphMapper);
    }

    @PostConstruct
    public void init() {
        LOG.info("==> AtlasPatchManager.init()");
        this.handlers.add(new UniqueAttributePatch(this.context));
        this.handlers.add(new ClassificationTextPatch(this.context));
        this.handlers.add(new FreeTextRequestHandlerPatch(this.context));
        this.handlers.add(new SuggestionsRequestHandlerPatch(this.context));
        this.handlers.add(new IndexConsistencyPatch(this.context));
        this.handlers.add(new ReIndexPatch(this.context));
        this.handlers.add(new ProcessNamePatch(this.context));
        LOG.info("<== AtlasPatchManager.init()");
    }

    public AtlasPatch.AtlasPatches getAllPatches() {
        return this.context.getPatchRegistry().getAllPatches();
    }

    public void applyAll() {
        LOG.info("==> AtlasPatchManager.applyAll()");
        try {
            for (AtlasPatchHandler handler : this.handlers) {
                AtlasPatch.PatchStatus patchStatus = handler.getStatusFromRegistry();
                if (patchStatus == AtlasPatch.PatchStatus.APPLIED || patchStatus == AtlasPatch.PatchStatus.SKIPPED) {
                    LOG.info("Ignoring java handler: {}; status: {}", (Object)handler.getPatchId(), (Object)patchStatus);
                    continue;
                }
                LOG.info("Applying java handler: {}; status: {}", (Object)handler.getPatchId(), (Object)patchStatus);
                handler.apply();
            }
        }
        catch (Exception ex) {
            LOG.error("Error applying patches.", (Throwable)ex);
        }
        LOG.info("<== AtlasPatchManager.applyAll()");
    }

    public void addPatchHandler(AtlasPatchHandler patchHandler) {
        this.handlers.add(patchHandler);
    }

    public PatchContext getContext() {
        return this.context;
    }
}

