/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasMetricJVMUtil;
import org.apache.atlas.util.AtlasMetricsUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
public class MetricsService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsService.class);
    public static final String TYPE = "type";
    public static final String TYPE_SUBTYPES = "typeAndSubTypes";
    public static final String ENTITY = "entity";
    public static final String TAG = "tag";
    public static final String GENERAL = "general";
    public static final String SYSTEM = "system";
    protected static final String METRIC_COLLECTION_TIME = "collectionTime";
    protected static final String METRIC_STATS = "stats";
    protected static final String METRIC_TYPE_COUNT = "typeCount";
    protected static final String METRIC_TYPE_UNUSED_COUNT = "typeUnusedCount";
    protected static final String METRIC_ENTITY_COUNT = "entityCount";
    protected static final String METRIC_ENTITY_DELETED = "entityDeleted";
    protected static final String METRIC_ENTITY_ACTIVE = "entityActive";
    protected static final String METRIC_ENTITY_SHELL = "entityShell";
    protected static final String METRIC_TAG_COUNT = "tagCount";
    protected static final String METRIC_ENTITIES_PER_TAG = "tagEntities";
    protected static final String METRIC_RUNTIME = "runtime";
    protected static final String METRIC_MEMORY = "memory";
    protected static final String METRIC_OS = "os";
    protected static final String METRIC_ENTITY_ACTIVE_INCL_SUBTYPES = "entityActive-typeAndSubTypes";
    protected static final String METRIC_ENTITY_DELETED_INCL_SUBTYPES = "entityDeleted-typeAndSubTypes";
    protected static final String METRIC_ENTITY_SHELL_INCL_SUBTYPES = "entityShell-typeAndSubTypes";
    private final AtlasGraph atlasGraph;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasMetricsUtil metricsUtil;
    private final String indexSearchPrefix = AtlasGraphUtilsV2.getIndexSearchPrefix();

    @Inject
    public MetricsService(AtlasGraph graph, AtlasTypeRegistry typeRegistry, AtlasMetricsUtil metricsUtil) {
        this.atlasGraph = graph;
        this.typeRegistry = typeRegistry;
        this.metricsUtil = metricsUtil;
    }

    @GraphTransaction
    public AtlasMetrics getMetrics() {
        AtlasTypesDef typesDef = this.getTypesDef();
        List entityDefs = typesDef.getEntityDefs();
        List classificationDefs = typesDef.getClassificationDefs();
        HashMap<String, Long> activeEntityCount = new HashMap<String, Long>();
        HashMap<String, Long> deletedEntityCount = new HashMap<String, Long>();
        HashMap<String, Long> shellEntityCount = new HashMap<String, Long>();
        HashMap<String, Long> taggedEntityCount = new HashMap<String, Long>();
        HashMap<String, Long> activeEntityCountTypeAndSubTypes = new HashMap<String, Long>();
        HashMap<String, Long> deletedEntityCountTypeAndSubTypes = new HashMap<String, Long>();
        HashMap<String, Long> shellEntityCountTypeAndSubTypes = new HashMap<String, Long>();
        long unusedTypeCount = 0L;
        long totalEntities = 0L;
        if (entityDefs != null) {
            for (AtlasEntityDef entityDef : entityDefs) {
                long activeCount = this.getTypeCount(entityDef.getName(), AtlasEntity.Status.ACTIVE);
                long deletedCount = this.getTypeCount(entityDef.getName(), AtlasEntity.Status.DELETED);
                long shellCount = this.getTypeShellCount(entityDef.getName());
                if (activeCount > 0L) {
                    activeEntityCount.put(entityDef.getName(), activeCount);
                    totalEntities += activeCount;
                }
                if (deletedCount > 0L) {
                    deletedEntityCount.put(entityDef.getName(), deletedCount);
                    totalEntities += deletedCount;
                }
                if (activeCount == 0L && deletedCount == 0L) {
                    ++unusedTypeCount;
                }
                if (shellCount <= 0L) continue;
                shellEntityCount.put(entityDef.getName(), shellCount);
            }
            for (AtlasEntityDef entityDef : entityDefs) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityDef.getName());
                long entityActiveCount = 0L;
                long entityDeletedCount = 0L;
                long entityShellCount = 0L;
                for (String type : entityType.getTypeAndAllSubTypes()) {
                    entityActiveCount += activeEntityCount.get(type) == null ? 0L : (Long)activeEntityCount.get(type);
                    entityDeletedCount += deletedEntityCount.get(type) == null ? 0L : (Long)deletedEntityCount.get(type);
                    entityShellCount += shellEntityCount.get(type) == null ? 0L : (Long)shellEntityCount.get(type);
                }
                if (entityActiveCount > 0L) {
                    activeEntityCountTypeAndSubTypes.put(entityType.getTypeName(), entityActiveCount);
                }
                if (entityDeletedCount > 0L) {
                    deletedEntityCountTypeAndSubTypes.put(entityType.getTypeName(), entityDeletedCount);
                }
                if (entityShellCount <= 0L) continue;
                shellEntityCountTypeAndSubTypes.put(entityType.getTypeName(), entityShellCount);
            }
        }
        if (classificationDefs != null) {
            for (AtlasClassificationDef classificationDef : classificationDefs) {
                long count = this.getTypeCount(classificationDef.getName(), AtlasEntity.Status.ACTIVE);
                if (count <= 0L) continue;
                taggedEntityCount.put(classificationDef.getName(), count);
            }
        }
        AtlasMetrics metrics = new AtlasMetrics();
        metrics.addMetric(GENERAL, METRIC_COLLECTION_TIME, (Object)System.currentTimeMillis());
        metrics.addMetric(GENERAL, METRIC_STATS, this.metricsUtil.getStats());
        metrics.addMetric(GENERAL, METRIC_TYPE_COUNT, (Object)this.getAllTypesCount());
        metrics.addMetric(GENERAL, METRIC_TAG_COUNT, (Object)this.getAllTagsCount());
        metrics.addMetric(GENERAL, METRIC_TYPE_UNUSED_COUNT, (Object)unusedTypeCount);
        metrics.addMetric(GENERAL, METRIC_ENTITY_COUNT, (Object)totalEntities);
        metrics.addMetric(ENTITY, METRIC_ENTITY_ACTIVE, activeEntityCount);
        metrics.addMetric(ENTITY, METRIC_ENTITY_DELETED, deletedEntityCount);
        metrics.addMetric(ENTITY, METRIC_ENTITY_SHELL, shellEntityCount);
        metrics.addMetric(ENTITY, METRIC_ENTITY_ACTIVE_INCL_SUBTYPES, activeEntityCountTypeAndSubTypes);
        metrics.addMetric(ENTITY, METRIC_ENTITY_DELETED_INCL_SUBTYPES, deletedEntityCountTypeAndSubTypes);
        metrics.addMetric(ENTITY, METRIC_ENTITY_SHELL_INCL_SUBTYPES, shellEntityCountTypeAndSubTypes);
        metrics.addMetric(TAG, METRIC_ENTITIES_PER_TAG, taggedEntityCount);
        metrics.addMetric(SYSTEM, METRIC_MEMORY, AtlasMetricJVMUtil.getMemoryDetails());
        metrics.addMetric(SYSTEM, METRIC_OS, AtlasMetricJVMUtil.getSystemInfo());
        metrics.addMetric(SYSTEM, METRIC_RUNTIME, AtlasMetricJVMUtil.getRuntimeInfo());
        return metrics;
    }

    private long getTypeCount(String typeName, AtlasEntity.Status status) {
        Long ret = null;
        String indexQuery = this.indexSearchPrefix + "\"" + Constants.ENTITY_TYPE_PROPERTY_KEY + "\" : (%s)" + " AND " + this.indexSearchPrefix + "\"" + Constants.STATE_PROPERTY_KEY + "\" : (%s)";
        indexQuery = String.format(indexQuery, typeName, status.name());
        try {
            ret = this.atlasGraph.indexQuery("vertex_index", indexQuery).vertexTotals();
        }
        catch (Exception e) {
            LOG.error("Failed fetching using indexQuery: " + e.getMessage());
        }
        return ret == null ? 0L : ret;
    }

    private long getTypeShellCount(String typeName) {
        Long ret = null;
        String indexQuery = this.indexSearchPrefix + "\"" + Constants.ENTITY_TYPE_PROPERTY_KEY + "\" : (%s)" + " AND " + this.indexSearchPrefix + "\"" + Constants.IS_INCOMPLETE_PROPERTY_KEY + "\" : " + Constants.INCOMPLETE_ENTITY_VALUE;
        indexQuery = String.format(indexQuery, typeName);
        try {
            ret = this.atlasGraph.indexQuery("vertex_index", indexQuery).vertexTotals();
        }
        catch (Exception e) {
            LOG.error("Failed fetching using indexQuery: " + e.getMessage());
        }
        return ret == null ? 0L : ret;
    }

    private int getAllTypesCount() {
        Collection allTypeNames = this.typeRegistry.getAllTypeNames();
        return CollectionUtils.isNotEmpty((Collection)allTypeNames) ? allTypeNames.size() : 0;
    }

    private int getAllTagsCount() {
        Collection allTagNames = this.typeRegistry.getAllClassificationDefNames();
        return CollectionUtils.isNotEmpty((Collection)allTagNames) ? allTagNames.size() : 0;
    }

    private AtlasTypesDef getTypesDef() {
        Collection classificationTypes;
        AtlasTypesDef ret = new AtlasTypesDef();
        Collection entityDefs = this.typeRegistry.getAllEntityDefs();
        if (CollectionUtils.isNotEmpty((Collection)entityDefs)) {
            for (AtlasEntityDef entityDef : entityDefs) {
                if (CollectionUtils.isNotEmpty((Collection)entityDef.getSuperTypes()) && entityDef.getSuperTypes().contains("__internal")) continue;
                ret.getEntityDefs().add(entityDef);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(classificationTypes = this.typeRegistry.getAllClassificationDefs()))) {
            ret.getClassificationDefs().addAll(classificationTypes);
        }
        AtlasAuthorizationUtils.filterTypesDef((AtlasTypesDefFilterRequest)new AtlasTypesDefFilterRequest(ret));
        return ret;
    }
}

