/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.params;

import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.web.params.AbstractParam;

public class BooleanParam
extends AbstractParam<Boolean> {
    public BooleanParam(String input) {
        super(input);
    }

    @Override
    protected String errorMessage(String input, Exception e) {
        return '\"' + input + "\" must be \"true\" or \"false\".";
    }

    @Override
    protected Boolean parse(String input) throws AtlasBaseException {
        if ("true".equalsIgnoreCase(input)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(input)) {
            return Boolean.FALSE;
        }
        throw new AtlasBaseException(AtlasErrorCode.PARAMETER_PARSING_FAILED, new String[]{"Boolean.parse: input=" + input});
    }
}

