/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.glossary.GlossaryTermUtils;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="v2/glossary")
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class GlossaryREST {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryREST.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.GlossaryREST");
    private final GlossaryService glossaryService;

    @Inject
    public GlossaryREST(GlossaryService glossaryService) {
        this.glossaryService = glossaryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Timed
    public List<AtlasGlossary> getGlossaries(@DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.getGlossaries()");
            }
            list = this.glossaryService.getGlossaries(Integer.parseInt(limit), Integer.parseInt(offset), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}")
    @Timed
    public AtlasGlossary getGlossary(@PathParam(value="glossaryGuid") String glossaryGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            AtlasGlossary ret;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossary(" + glossaryGuid + ")"));
            }
            if ((ret = this.glossaryService.getGlossary(glossaryGuid)) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[0]);
            }
            AtlasGlossary atlasGlossary = ret;
            return atlasGlossary;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}/detailed")
    @Timed
    public AtlasGlossary.AtlasGlossaryExtInfo getDetailedGlossary(@PathParam(value="glossaryGuid") String glossaryGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            AtlasGlossary.AtlasGlossaryExtInfo ret;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getDetailedGlossary(" + glossaryGuid + ")"));
            }
            if ((ret = this.glossaryService.getDetailedGlossary(glossaryGuid)) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[0]);
            }
            AtlasGlossary.AtlasGlossaryExtInfo atlasGlossaryExtInfo = ret;
            return atlasGlossaryExtInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/term/{termGuid}")
    @Timed
    public AtlasGlossaryTerm getGlossaryTerm(@PathParam(value="termGuid") String termGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            AtlasGlossaryTerm ret;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryTerm(" + termGuid + ")"));
            }
            if ((ret = this.glossaryService.getTerm(termGuid)) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[0]);
            }
            AtlasGlossaryTerm atlasGlossaryTerm = ret;
            return atlasGlossaryTerm;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/category/{categoryGuid}")
    @Timed
    public AtlasGlossaryCategory getGlossaryCategory(@PathParam(value="categoryGuid") String categoryGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("categoryGuid", categoryGuid);
        AtlasPerfTracer perf = null;
        try {
            AtlasGlossaryCategory ret;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryCategory(" + categoryGuid + ")"));
            }
            if ((ret = this.glossaryService.getCategory(categoryGuid)) == null) {
                throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[0]);
            }
            AtlasGlossaryCategory atlasGlossaryCategory = ret;
            return atlasGlossaryCategory;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Timed
    public AtlasGlossary createGlossary(AtlasGlossary atlasGlossary) throws AtlasBaseException {
        AtlasGlossary atlasGlossary2;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.createGlossary()");
            }
            atlasGlossary2 = this.glossaryService.createGlossary(atlasGlossary);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossary2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/term")
    @Timed
    public AtlasGlossaryTerm createGlossaryTerm(AtlasGlossaryTerm glossaryTerm) throws AtlasBaseException {
        AtlasGlossaryTerm atlasGlossaryTerm;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.createGlossaryTerm()");
            }
            if (Objects.isNull(glossaryTerm.getAnchor())) {
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
            }
            atlasGlossaryTerm = this.glossaryService.createTerm(glossaryTerm);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/terms")
    @Timed
    public List<AtlasGlossaryTerm> createGlossaryTerms(List<AtlasGlossaryTerm> glossaryTerm) throws AtlasBaseException {
        List list;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.createGlossaryTerms()");
            }
            for (AtlasGlossaryTerm term : glossaryTerm) {
                if (!Objects.isNull(term.getAnchor())) continue;
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
            }
            list = this.glossaryService.createTerms(glossaryTerm);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/category")
    @Timed
    public AtlasGlossaryCategory createGlossaryCategory(AtlasGlossaryCategory glossaryCategory) throws AtlasBaseException {
        AtlasGlossaryCategory atlasGlossaryCategory;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.createGlossaryCategory()");
            }
            if (Objects.isNull(glossaryCategory.getAnchor())) {
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
            }
            atlasGlossaryCategory = this.glossaryService.createCategory(glossaryCategory);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/categories")
    @Timed
    public List<AtlasGlossaryCategory> createGlossaryCategories(List<AtlasGlossaryCategory> glossaryCategory) throws AtlasBaseException {
        List list;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.createGlossaryCategories()");
            }
            for (AtlasGlossaryCategory category : glossaryCategory) {
                if (!Objects.isNull(category.getAnchor())) continue;
                throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
            }
            list = this.glossaryService.createCategories(glossaryCategory);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{glossaryGuid}")
    @Timed
    public AtlasGlossary updateGlossary(@PathParam(value="glossaryGuid") String glossaryGuid, AtlasGlossary updatedGlossary) throws AtlasBaseException {
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.updateGlossary(" + glossaryGuid + ")"));
            }
            updatedGlossary.setGuid(glossaryGuid);
            AtlasGlossary atlasGlossary = this.glossaryService.updateGlossary(updatedGlossary);
            return atlasGlossary;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{glossaryGuid}/partial")
    @Timed
    public AtlasGlossary partialUpdateGlossary(@PathParam(value="glossaryGuid") String glossaryGuid, Map<String, String> partialUpdates) throws AtlasBaseException {
        AtlasGlossary atlasGlossary;
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.partialUpdateGlossary()");
            }
            if (MapUtils.isEmpty(partialUpdates)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"PartialUpdates missing or empty"});
            }
            AtlasGlossary glossary = this.glossaryService.getGlossary(glossaryGuid);
            for (Map.Entry<String, String> entry : partialUpdates.entrySet()) {
                try {
                    glossary.setAttribute(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARTIAL_UPDATE_ATTR, new String[]{entry.getKey(), "Glossary"});
                }
            }
            atlasGlossary = this.glossaryService.updateGlossary(glossary);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/term/{termGuid}")
    @Timed
    public AtlasGlossaryTerm updateGlossaryTerm(@PathParam(value="termGuid") String termGuid, AtlasGlossaryTerm glossaryTerm) throws AtlasBaseException {
        AtlasGlossaryTerm atlasGlossaryTerm;
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.updateGlossaryTerm()");
            }
            glossaryTerm.setGuid(termGuid);
            atlasGlossaryTerm = this.glossaryService.updateTerm(glossaryTerm);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/term/{termGuid}/partial")
    @Timed
    public AtlasGlossaryTerm partialUpdateGlossaryTerm(@PathParam(value="termGuid") String termGuid, Map<String, String> partialUpdates) throws AtlasBaseException {
        AtlasGlossaryTerm atlasGlossaryTerm;
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.partialUpdateGlossaryTerm()");
            }
            if (MapUtils.isEmpty(partialUpdates)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"PartialUpdates missing or empty"});
            }
            AtlasGlossaryTerm glossaryTerm = this.glossaryService.getTerm(termGuid);
            for (Map.Entry<String, String> entry : partialUpdates.entrySet()) {
                try {
                    glossaryTerm.setAttribute(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARTIAL_UPDATE_ATTR, new String[]{"Glossary Term", entry.getKey()});
                }
            }
            atlasGlossaryTerm = this.glossaryService.updateTerm(glossaryTerm);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/category/{categoryGuid}")
    @Timed
    public AtlasGlossaryCategory updateGlossaryCategory(@PathParam(value="categoryGuid") String categoryGuid, AtlasGlossaryCategory glossaryCategory) throws AtlasBaseException {
        AtlasGlossaryCategory atlasGlossaryCategory;
        Servlets.validateQueryParamLength("categoryGuid", categoryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.updateGlossaryCategory()");
            }
            glossaryCategory.setGuid(categoryGuid);
            atlasGlossaryCategory = this.glossaryService.updateCategory(glossaryCategory);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/category/{categoryGuid}/partial")
    @Timed
    public AtlasGlossaryCategory partialUpdateGlossaryCategory(@PathParam(value="categoryGuid") String categoryGuid, Map<String, String> partialUpdates) throws AtlasBaseException {
        AtlasGlossaryCategory atlasGlossaryCategory;
        Servlets.validateQueryParamLength("categoryGuid", categoryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.partialUpdateGlossaryCategory()");
            }
            if (MapUtils.isEmpty(partialUpdates)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"PartialUpdates missing or empty"});
            }
            AtlasGlossaryCategory glossaryCategory = this.glossaryService.getCategory(categoryGuid);
            for (Map.Entry<String, String> entry : partialUpdates.entrySet()) {
                try {
                    glossaryCategory.setAttribute(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARTIAL_UPDATE_ATTR, new String[]{"Glossary Category", entry.getKey()});
                }
            }
            atlasGlossaryCategory = this.glossaryService.updateCategory(glossaryCategory);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasGlossaryCategory;
    }

    @DELETE
    @Path(value="/{glossaryGuid}")
    @Timed
    public void deleteGlossary(@PathParam(value="glossaryGuid") String glossaryGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.deleteGlossary(" + glossaryGuid + ")"));
            }
            this.glossaryService.deleteGlossary(glossaryGuid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/term/{termGuid}")
    @Timed
    public void deleteGlossaryTerm(@PathParam(value="termGuid") String termGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.deleteGlossaryTerm(" + termGuid + ")"));
            }
            this.glossaryService.deleteTerm(termGuid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/category/{categoryGuid}")
    @Timed
    public void deleteGlossaryCategory(@PathParam(value="categoryGuid") String categoryGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("categoryGuid", categoryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.deleteGlossaryCategory(" + categoryGuid + ")"));
            }
            this.glossaryService.deleteCategory(categoryGuid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}/terms")
    @Timed
    public List<AtlasGlossaryTerm> getGlossaryTerms(@PathParam(value="glossaryGuid") String glossaryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryTerms(" + glossaryGuid + ")"));
            }
            list = this.glossaryService.getGlossaryTerms(glossaryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}/terms/headers")
    @Timed
    public List<AtlasRelatedTermHeader> getGlossaryTermHeaders(@PathParam(value="glossaryGuid") String glossaryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryTermHeaders(" + glossaryGuid + ")"));
            }
            list = this.glossaryService.getGlossaryTermsHeaders(glossaryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}/categories")
    @Timed
    public List<AtlasGlossaryCategory> getGlossaryCategories(@PathParam(value="glossaryGuid") String glossaryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryCategories(" + glossaryGuid + ")"));
            }
            list = this.glossaryService.getGlossaryCategories(glossaryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{glossaryGuid}/categories/headers")
    @Timed
    public List<AtlasRelatedCategoryHeader> getGlossaryCategoriesHeaders(@PathParam(value="glossaryGuid") String glossaryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("glossaryGuid", glossaryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getGlossaryCategoriesHeaders(" + glossaryGuid + ")"));
            }
            list = this.glossaryService.getGlossaryCategoriesHeaders(glossaryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/category/{categoryGuid}/terms")
    @Timed
    public List<AtlasRelatedTermHeader> getCategoryTerms(@PathParam(value="categoryGuid") String categoryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("categoryGuid", categoryGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getCategoryTerms(" + categoryGuid + ")"));
            }
            list = this.glossaryService.getCategoryTerms(categoryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/terms/{termGuid}/related")
    @Timed
    public Map<AtlasGlossaryTerm.Relation, Set<AtlasRelatedTermHeader>> getRelatedTerms(@PathParam(value="termGuid") String termGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        Map map;
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getRelatedTermsInfo(" + termGuid + ")"));
            }
            map = this.glossaryService.getRelatedTerms(termGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/terms/{termGuid}/assignedEntities")
    @Timed
    public List<AtlasRelatedObjectId> getEntitiesAssignedWithTerm(@PathParam(value="termGuid") String termGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        List list;
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.getEntitiesAssignedWithTerm(" + termGuid + ")"));
            }
            list = this.glossaryService.getAssignedEntities(termGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/terms/{termGuid}/assignedEntities")
    @Timed
    public void assignTermToEntities(@PathParam(value="termGuid") String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.assignTermToEntities(" + termGuid + ")"));
            }
            this.glossaryService.assignTermToEntities(termGuid, relatedObjectIds);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/terms/{termGuid}/assignedEntities")
    @Timed
    public void removeTermAssignmentFromEntities(@PathParam(value="termGuid") String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        this.removeTermFromGlossary(termGuid, relatedObjectIds);
    }

    @PUT
    @Path(value="/terms/{termGuid}/assignedEntities")
    @Timed
    public void disassociateTermAssignmentFromEntities(@PathParam(value="termGuid") String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        this.removeTermFromGlossary(termGuid, relatedObjectIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTermFromGlossary(String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        Servlets.validateQueryParamLength("termGuid", termGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("GlossaryREST.removeTermFromGlossary(" + termGuid + ")"));
            }
            this.glossaryService.removeTermFromEntities(termGuid, relatedObjectIds);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/category/{categoryGuid}/related")
    @Timed
    public Map<String, List<AtlasRelatedCategoryHeader>> getRelatedCategories(@PathParam(value="categoryGuid") String categoryGuid, @DefaultValue(value="-1") @QueryParam(value="limit") String limit, @DefaultValue(value="0") @QueryParam(value="offset") String offset, @DefaultValue(value="ASC") @QueryParam(value="sort") String sort) throws AtlasBaseException {
        Map map;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"GlossaryREST.getRelatedCategories()");
            }
            map = this.glossaryService.getRelatedCategories(categoryGuid, Integer.parseInt(offset), Integer.parseInt(limit), this.toSortOrder(sort));
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return map;
    }

    private SortOrder toSortOrder(String sort) {
        SortOrder ret = SortOrder.ASCENDING;
        if (!"ASC".equals(sort) && "DESC".equals(sort)) {
            ret = SortOrder.DESCENDING;
        }
        return ret;
    }

    @GET
    @Path(value="/import/template")
    @Produces(value={"application/octet-stream"})
    public StreamingOutput produceTemplate() {
        return new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                outputStream.write(GlossaryTermUtils.getGlossaryTermHeaders().getBytes());
            }
        };
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Timed
    public BulkImportResponse importGlossaryData(@FormDataParam(value="file") InputStream inputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws AtlasBaseException {
        return this.glossaryService.importGlossaryData(inputStream, fileDetail.getFileName());
    }
}

