/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.aspectj.lang.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(context="atlas-debug-metrics-context")
public class AtlasDebugMetricsSource {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasDebugMetricsSource.class);
    @Metric(always=true)
    protected MutableRate entityREST_getById;
    @Metric(always=true)
    protected MutableRate entityREST_createOrUpdate;
    @Metric(always=true)
    protected MutableRate entityREST_partialUpdateEntityAttrByGuid;
    @Metric(always=true)
    protected MutableRate entityREST_deleteByGuid;
    @Metric(always=true)
    protected MutableRate entityREST_getClassification;
    @Metric(always=true)
    protected MutableRate entityREST_getClassifications;
    @Metric(always=true)
    protected MutableRate entityREST_addClassificationsByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_addClassifications;
    @Metric(always=true)
    protected MutableRate entityREST_deleteClassificationByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_deleteClassification;
    @Metric(always=true)
    protected MutableRate entityREST_getHeaderById;
    @Metric(always=true)
    protected MutableRate entityREST_getEntityHeaderByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_getByUniqueAttributes;
    @Metric(always=true)
    protected MutableRate entityREST_partialUpdateEntityByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_deleteByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_updateClassificationsByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_updateClassifications;
    @Metric(always=true)
    protected MutableRate entityREST_getEntitiesByUniqAttr;
    @Metric(always=true)
    protected MutableRate entityREST_getByGuids;
    @Metric(always=true)
    protected MutableRate entityREST_createOrUpdateBulk;
    @Metric(always=true)
    protected MutableRate entityREST_deleteByGuids;
    @Metric(always=true)
    protected MutableRate entityREST_addClassification;
    @Metric(always=true)
    protected MutableRate entityREST_getAuditEvents;
    @Metric(always=true)
    protected MutableRate entityREST_getEntityHeaders;
    @Metric(always=true)
    protected MutableRate entityREST_setClassifications;
    @Metric(always=true)
    protected MutableRate entityREST_addOrUpdateBusinessAttributes;
    @Metric(always=true)
    protected MutableRate entityREST_removeBusinessAttributes;
    @Metric(always=true)
    protected MutableRate entityREST_addOrUpdateBusinessAttributesByName;
    @Metric(always=true)
    protected MutableRate entityREST_removeBusinessAttributesByName;
    @Metric(always=true)
    protected MutableRate entityREST_setLabels;
    @Metric(always=true)
    protected MutableRate entityREST_addLabels;
    @Metric(always=true)
    protected MutableRate entityREST_removeLabels;
    @Metric(always=true)
    protected MutableRate entityREST_removeLabelsByTypeName;
    @Metric(always=true)
    protected MutableRate entityREST_setLabelsByTypeName;
    @Metric(always=true)
    protected MutableRate entityREST_addLabelsByTypeName;
    @Metric(always=true)
    protected MutableRate entityREST_importBMAttributes;
    @Metric(always=true)
    protected MutableRate typesREST_getEntityDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getTypeDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getTypeDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getTypeDefHeaders;
    @Metric(always=true)
    protected MutableRate typesREST_getAllTypeDefs;
    @Metric(always=true)
    protected MutableRate typesREST_getEnumDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getEnumDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getStructDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getStructDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getClassificationDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getClassificationDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getEntityDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getRelationshipDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_getRelationshipDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getBusinessMetadataDefByGuid;
    @Metric(always=true)
    protected MutableRate typesREST_getBusinessMetadataDefByName;
    @Metric(always=true)
    protected MutableRate typesREST_createAtlasTypeDefs;
    @Metric(always=true)
    protected MutableRate typesREST_updateAtlasTypeDefs;
    @Metric(always=true)
    protected MutableRate typesREST_deleteAtlasTypeDefs;
    @Metric(always=true)
    protected MutableRate typesREST_deleteAtlasTypeByName;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaries;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_getDetailedGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryCategory;
    @Metric(always=true)
    protected MutableRate glossaryREST_createGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_createGlossaryTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_createGlossaryTerms;
    @Metric(always=true)
    protected MutableRate glossaryREST_createGlossaryCategory;
    @Metric(always=true)
    protected MutableRate glossaryREST_createGlossaryCategories;
    @Metric(always=true)
    protected MutableRate glossaryREST_updateGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_partialUpdateGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_updateGlossaryTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_partialUpdateGlossaryTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_updateGlossaryCategory;
    @Metric(always=true)
    protected MutableRate glossaryREST_partialUpdateGlossaryCategory;
    @Metric(always=true)
    protected MutableRate glossaryREST_deleteGlossary;
    @Metric(always=true)
    protected MutableRate glossaryREST_deleteGlossaryTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_deleteGlossaryCategory;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryTerms;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryTermHeaders;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryCategories;
    @Metric(always=true)
    protected MutableRate glossaryREST_getGlossaryCategoriesHeaders;
    @Metric(always=true)
    protected MutableRate glossaryREST_getCategoryTerms;
    @Metric(always=true)
    protected MutableRate glossaryREST_getRelatedTerms;
    @Metric(always=true)
    protected MutableRate glossaryREST_getEntitiesAssignedWithTerm;
    @Metric(always=true)
    protected MutableRate glossaryREST_assignTermToEntities;
    @Metric(always=true)
    protected MutableRate glossaryREST_removeTermAssignmentFromEntities;
    @Metric(always=true)
    protected MutableRate glossaryREST_disassociateTermAssignmentFromEntities;
    @Metric(always=true)
    protected MutableRate glossaryREST_getRelatedCategories;
    @Metric(always=true)
    protected MutableRate glossaryREST_importGlossaryData;
    @Metric(always=true)
    protected MutableRate discoveryREST_quickSearchQuickSearchParams;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchUsingFullText;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchUsingAttribute;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchWithParameters;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchRelatedEntities;
    @Metric(always=true)
    protected MutableRate discoveryREST_updateSavedSearch;
    @Metric(always=true)
    protected MutableRate discoveryREST_getSavedSearch;
    @Metric(always=true)
    protected MutableRate discoveryREST_getSavedSearches;
    @Metric(always=true)
    protected MutableRate discoveryREST_deleteSavedSearch;
    @Metric(always=true)
    protected MutableRate discoveryREST_executeSavedSearchByName;
    @Metric(always=true)
    protected MutableRate discoveryREST_executeSavedSearchByGuid;
    @Metric(always=true)
    protected MutableRate discoveryREST_getSuggestions;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchUsingDSL;
    @Metric(always=true)
    protected MutableRate discoveryREST_searchUsingBasic;
    @Metric(always=true)
    protected MutableRate discoveryREST_quickSearch;
    @Metric(always=true)
    protected MutableRate discoveryREST_addSavedSearch;
    @Metric(always=true)
    protected MutableRate notificationHookConsumer_doWork;
    @Metric(always=true)
    protected MutableRate lineageREST_getLineageByUniqAttr;
    @Metric(always=true)
    protected MutableRate lineageREST_getLineageGraph;
    @Metric(always=true)
    protected MutableRate relationshipREST_create;
    @Metric(always=true)
    protected MutableRate relationshipREST_update;
    @Metric(always=true)
    protected MutableRate relationshipREST_getById;
    @Metric(always=true)
    protected MutableRate relationshipREST_deleteById;
    public static final Map<String, String> fieldLowerCaseUpperCaseMap = new HashMap<String, String>();
    public static final Set<String> debugMetricsAttributes = new HashSet<String>();

    public AtlasDebugMetricsSource() {
        this.initAttrList();
        this.populateFieldList();
    }

    public void update(Signature name, Long timeConsumed) {
        String signatureName;
        switch (signatureName = name.toString()) {
            case "EntityMutationResponse org.apache.atlas.web.rest.EntityREST.createOrUpdate(AtlasEntitiesWithExtInfo)": {
                this.entityREST_createOrUpdateBulk.add(timeConsumed.longValue());
                break;
            }
            case "void org.apache.atlas.web.rest.EntityREST.addOrUpdateBusinessAttributes(String,String,Map)": {
                this.entityREST_addOrUpdateBusinessAttributesByName.add(timeConsumed.longValue());
                break;
            }
            case "void org.apache.atlas.web.rest.EntityREST.removeBusinessAttributes(String,String,Map)": {
                this.entityREST_removeBusinessAttributesByName.add(timeConsumed.longValue());
                break;
            }
            case "void org.apache.atlas.web.rest.EntityREST.removeLabels(String,Set,HttpServletRequest)": {
                this.entityREST_removeLabelsByTypeName.add(timeConsumed.longValue());
                break;
            }
            case "void org.apache.atlas.web.rest.EntityREST.setLabels(String,Set,HttpServletRequest)": {
                this.entityREST_setLabelsByTypeName.add(timeConsumed.longValue());
                break;
            }
            case "void org.apache.atlas.web.rest.EntityREST.addLabels(String,Set,HttpServletRequest)": {
                this.entityREST_addLabelsByTypeName.add(timeConsumed.longValue());
                break;
            }
            case "AtlasQuickSearchResult org.apache.atlas.web.rest.DiscoveryREST.quickSearch(QuickSearchParameters)": {
                this.discoveryREST_quickSearchQuickSearchParams.add(timeConsumed.longValue());
                break;
            }
            default: {
                this.update(name.toShortString(), timeConsumed);
            }
        }
    }

    private void populateFieldList() {
        Field[] fields = AtlasDebugMetricsSource.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getAnnotation(Metric.class) == null) continue;
            String name = fields[i].getName();
            for (String metricName : debugMetricsAttributes) {
                fieldLowerCaseUpperCaseMap.put(name.toLowerCase() + metricName, StringUtils.capitalize((String)name));
            }
        }
    }

    private void initAttrList() {
        debugMetricsAttributes.add("numops");
        debugMetricsAttributes.add("mintime");
        debugMetricsAttributes.add("stdevtime");
        debugMetricsAttributes.add("maxtime");
        debugMetricsAttributes.add("avgtime");
    }

    private void update(String name, Long timeConsumed) {
        switch (name) {
            case "RelationshipREST.create(..)": {
                this.relationshipREST_create.add(timeConsumed.longValue());
                break;
            }
            case "RelationshipREST.update(..)": {
                this.relationshipREST_update.add(timeConsumed.longValue());
                break;
            }
            case "RelationshipREST.getById(..)": {
                this.relationshipREST_getById.add(timeConsumed.longValue());
                break;
            }
            case "RelationshipREST.deleteById(..)": {
                this.relationshipREST_deleteById.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchUsingFullText(..)": {
                this.discoveryREST_searchUsingFullText.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchUsingAttribute(..)": {
                this.discoveryREST_searchUsingAttribute.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchWithParameters(..)": {
                this.discoveryREST_searchWithParameters.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchRelatedEntities(..)": {
                this.discoveryREST_searchRelatedEntities.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.updateSavedSearch(..)": {
                this.discoveryREST_updateSavedSearch.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.getSavedSearch(..)": {
                this.discoveryREST_getSavedSearch.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.getSavedSearches(..)": {
                this.discoveryREST_getSavedSearches.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.deleteSavedSearch(..)": {
                this.discoveryREST_deleteSavedSearch.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.executeSavedSearchByName(..)": {
                this.discoveryREST_executeSavedSearchByName.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.executeSavedSearchByGuid(..)": {
                this.discoveryREST_executeSavedSearchByGuid.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.getSuggestions(..)": {
                this.discoveryREST_getSuggestions.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaries(..)": {
                this.glossaryREST_getGlossaries.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossary(..)": {
                this.glossaryREST_getGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getDetailedGlossary(..)": {
                this.glossaryREST_getDetailedGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryTerm(..)": {
                this.glossaryREST_getGlossaryTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryCategory(..)": {
                this.glossaryREST_getGlossaryCategory.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.createGlossary(..)": {
                this.glossaryREST_createGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.createGlossaryTerm(..)": {
                this.glossaryREST_createGlossaryTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.createGlossaryTerms(..)": {
                this.glossaryREST_createGlossaryTerms.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.createGlossaryCategory(..)": {
                this.glossaryREST_createGlossaryCategory.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.createGlossaryCategories(..)": {
                this.glossaryREST_createGlossaryCategories.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.updateGlossary(..)": {
                this.glossaryREST_updateGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.partialUpdateGlossary(..)": {
                this.glossaryREST_partialUpdateGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.updateGlossaryTerm(..)": {
                this.glossaryREST_updateGlossaryTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.partialUpdateGlossaryTerm(..)": {
                this.glossaryREST_partialUpdateGlossaryTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.updateGlossaryCategory(..)": {
                this.glossaryREST_updateGlossaryCategory.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.partialUpdateGlossaryCategory(..)": {
                this.glossaryREST_partialUpdateGlossaryCategory.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.deleteGlossary(..)": {
                this.glossaryREST_deleteGlossary.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.deleteGlossaryTerm(..)": {
                this.glossaryREST_deleteGlossaryTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.deleteGlossaryCategory(..)": {
                this.glossaryREST_deleteGlossaryCategory.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryTerms(..)": {
                this.glossaryREST_getGlossaryTerms.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryTermHeaders(..)": {
                this.glossaryREST_getGlossaryTermHeaders.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryCategories(..)": {
                this.glossaryREST_getGlossaryCategories.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getGlossaryCategoriesHeaders(..)": {
                this.glossaryREST_getGlossaryCategoriesHeaders.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getCategoryTerms(..)": {
                this.glossaryREST_getCategoryTerms.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getRelatedTerms(..)": {
                this.glossaryREST_getRelatedTerms.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getEntitiesAssignedWithTerm(..)": {
                this.glossaryREST_getEntitiesAssignedWithTerm.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.assignTermToEntities(..)": {
                this.glossaryREST_assignTermToEntities.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.removeTermAssignmentFromEntities(..)": {
                this.glossaryREST_removeTermAssignmentFromEntities.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.disassociateTermAssignmentFromEntities(..)": {
                this.glossaryREST_disassociateTermAssignmentFromEntities.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.getRelatedCategories(..)": {
                this.glossaryREST_getRelatedCategories.add(timeConsumed.longValue());
                break;
            }
            case "GlossaryREST.importGlossaryData(..)": {
                this.glossaryREST_importGlossaryData.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getTypeDefByName(..)": {
                this.typesREST_getTypeDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getTypeDefByGuid(..)": {
                this.typesREST_getTypeDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getTypeDefHeaders(..)": {
                this.typesREST_getTypeDefHeaders.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getAllTypeDefs(..)": {
                this.typesREST_getAllTypeDefs.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getEnumDefByName(..)": {
                this.typesREST_getEnumDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getEnumDefByGuid(..)": {
                this.typesREST_getEnumDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getStructDefByName(..)": {
                this.typesREST_getStructDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getStructDefByGuid(..)": {
                this.typesREST_getStructDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getClassificationDefByName(..)": {
                this.typesREST_getClassificationDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getClassificationDefByGuid(..)": {
                this.typesREST_getClassificationDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getEntityDefByName(..)": {
                this.typesREST_getEntityDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getEntityDefByGuid(..)": {
                this.typesREST_getEntityDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getRelationshipDefByName(..)": {
                this.typesREST_getRelationshipDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getRelationshipDefByGuid(..)": {
                this.typesREST_getRelationshipDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getBusinessMetadataDefByGuid(..)": {
                this.typesREST_getBusinessMetadataDefByGuid.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.getBusinessMetadataDefByName(..)": {
                this.typesREST_getBusinessMetadataDefByName.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.createAtlasTypeDefs(..)": {
                this.typesREST_createAtlasTypeDefs.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.updateAtlasTypeDefs(..)": {
                this.typesREST_updateAtlasTypeDefs.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.deleteAtlasTypeDefs(..)": {
                this.typesREST_deleteAtlasTypeDefs.add(timeConsumed.longValue());
                break;
            }
            case "TypesREST.deleteAtlasTypeByName(..)": {
                this.typesREST_deleteAtlasTypeByName.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getHeaderById(..)": {
                this.entityREST_getHeaderById.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getEntityHeaderByUniqueAttributes(..)": {
                this.entityREST_getEntityHeaderByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getByUniqueAttributes(..)": {
                this.entityREST_getByUniqueAttributes.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.partialUpdateEntityByUniqueAttrs(..)": {
                this.entityREST_partialUpdateEntityByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.deleteByUniqueAttribute(..)": {
                this.entityREST_deleteByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.updateClassificationsByUniqueAttribute(..)": {
                this.entityREST_updateClassificationsByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.updateClassifications(..)": {
                this.entityREST_updateClassifications.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getEntitiesByUniqueAttributes(..)": {
                this.entityREST_getEntitiesByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getByGuids(..)": {
                this.entityREST_getByGuids.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.deleteByGuids(..)": {
                this.entityREST_deleteByGuids.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.addClassification(..)": {
                this.entityREST_addClassification.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getAuditEvents(..)": {
                this.entityREST_getAuditEvents.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getEntityHeaders(..)": {
                this.entityREST_getEntityHeaders.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.setClassifications(..)": {
                this.entityREST_setClassifications.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.addOrUpdateBusinessAttributes(..)": {
                this.entityREST_addOrUpdateBusinessAttributes.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.removeBusinessAttributes(..)": {
                this.entityREST_removeBusinessAttributes.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.setLabels(..)": {
                this.entityREST_setLabels.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.addLabels(..)": {
                this.entityREST_addLabels.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.removeLabels(..)": {
                this.entityREST_removeLabels.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getById(..)": {
                this.entityREST_getById.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.createOrUpdate(..)": {
                this.entityREST_createOrUpdate.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.partialUpdateEntityAttrByGuid(..)": {
                this.entityREST_partialUpdateEntityAttrByGuid.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.deleteByGuid(..)": {
                this.entityREST_deleteByGuid.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getClassification(..)": {
                this.entityREST_getClassification.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.getClassifications(..)": {
                this.entityREST_getClassifications.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.addClassificationsByUniqueAttribute(..)": {
                this.entityREST_addClassificationsByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.addClassifications(..)": {
                this.entityREST_addClassifications.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.deleteClassificationByUniqueAttribute(..)": {
                this.entityREST_deleteClassificationByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.deleteClassification(..)": {
                this.entityREST_deleteClassification.add(timeConsumed.longValue());
                break;
            }
            case "EntityREST.importBMAttributes(..)": {
                this.entityREST_importBMAttributes.add(timeConsumed.longValue());
                break;
            }
            case "NotificationHookConsumer.doWork(..)": {
                this.notificationHookConsumer_doWork.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchUsingDSL(..)": {
                this.discoveryREST_searchUsingDSL.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.searchUsingBasic(..)": {
                this.discoveryREST_searchUsingBasic.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.quickSearch(..)": {
                this.discoveryREST_quickSearch.add(timeConsumed.longValue());
                break;
            }
            case "DiscoveryREST.addSavedSearch(..)": {
                this.discoveryREST_addSavedSearch.add(timeConsumed.longValue());
                break;
            }
            case "LineageREST.getLineageByUniqueAttribute(..)": {
                this.lineageREST_getLineageByUniqAttr.add(timeConsumed.longValue());
                break;
            }
            case "LineageREST.getLineageGraph(..)": {
                this.lineageREST_getLineageGraph.add(timeConsumed.longValue());
                break;
            }
            default: {
                LOG.error("The signature '{}' is not handled!", (Object)name);
            }
        }
    }
}

