/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.QueryException;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.ElementQuery;
import org.janusgraph.graphdb.query.QueryExecutor;
import org.janusgraph.graphdb.query.ResultMergeSortIterator;
import org.janusgraph.graphdb.query.ResultSetIterator;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.util.CloseableIteratorUtils;

public class QueryProcessor<Q extends ElementQuery<R, B>, R extends JanusGraphElement, B extends BackendQuery<B>>
implements Iterable<R> {
    private static final int MAX_SORT_ITERATION = 1000000;
    private final Q query;
    private final QueryExecutor<Q, R, B> executor;

    public QueryProcessor(Q query, QueryExecutor<Q, R, B> executor) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(executor);
        this.query = query;
        this.executor = executor;
    }

    @Override
    public CloseableIterator<R> iterator() {
        if (this.query.isEmpty()) {
            return CloseableIteratorUtils.emptyIterator();
        }
        return new ResultSetIterator<R>(this.getUnfoldedIterator(), this.query.hasLimit() ? this.query.getLimit() : Integer.MAX_VALUE);
    }

    private Iterator<R> getUnfoldedIterator() {
        ResultMergeSortIterator iterator = null;
        boolean hasDeletions = this.executor.hasDeletions(this.query);
        Iterator<R> newElements = this.executor.getNew(this.query);
        if (this.query.isSorted()) {
            for (int i = this.query.numSubQueries() - 1; i >= 0; --i) {
                BackendQueryHolder subquery = this.query.getSubQuery(i);
                ResultMergeSortIterator subqueryIterator = this.getFilterIterator((CloseableIterator<R>)(subquery.isSorted() ? new LimitAdjustingIterator(subquery) : new PreSortingIterator(subquery)), hasDeletions, !subquery.isFitted());
                iterator = iterator == null ? subqueryIterator : new ResultMergeSortIterator(subqueryIterator, iterator, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
            Preconditions.checkArgument((iterator != null ? 1 : 0) != 0);
            if (newElements.hasNext()) {
                ArrayList allNew = Lists.newArrayList(newElements);
                allNew.sort(this.query.getSortOrder());
                iterator = new ResultMergeSortIterator(allNew.iterator(), iterator, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
        } else {
            HashSet allNew = newElements.hasNext() ? Sets.newHashSet(newElements) : ImmutableSet.of();
            ArrayList iterators = new ArrayList(this.query.numSubQueries());
            for (int i = 0; i < this.query.numSubQueries(); ++i) {
                BackendQueryHolder subquery = this.query.getSubQuery(i);
                Object subIterator = new CloseableIterator<R>(subquery);
                subIterator = this.getFilterIterator((CloseableIterator<R>)subIterator, hasDeletions, !subquery.isFitted());
                if (!allNew.isEmpty()) {
                    subIterator = CloseableIteratorUtils.filter(subIterator, r -> !allNew.contains(r));
                }
                iterators.add(subIterator);
            }
            if (iterators.size() > 1) {
                iterator = CloseableIteratorUtils.concat(iterators);
                if (this.query.hasDuplicateResults()) {
                    HashSet seenResults = new HashSet();
                    iterator = CloseableIteratorUtils.filter(iterator, r -> {
                        if (seenResults.contains(r)) {
                            return false;
                        }
                        seenResults.add(r);
                        return true;
                    });
                }
            } else {
                iterator = (Iterator)iterators.get(0);
            }
            if (!allNew.isEmpty()) {
                iterator = CloseableIteratorUtils.concat(new Iterator[]{allNew.iterator(), iterator});
            }
        }
        return iterator;
    }

    private CloseableIterator<R> getFilterIterator(CloseableIterator<R> iterator, boolean filterDeletions, boolean filterMatches) {
        if (filterDeletions || filterMatches) {
            return CloseableIteratorUtils.filter(iterator, r -> !(filterDeletions && this.executor.isDeleted(this.query, (JanusGraphElement)r) || filterMatches && !this.query.matches((JanusGraphElement)r)));
        }
        return iterator;
    }

    private final class LimitAdjustingIterator
    extends org.janusgraph.graphdb.query.LimitAdjustingIterator<R> {
        private B backendQuery;
        private final QueryProfiler profiler;
        private final Object executionInfo;

        private LimitAdjustingIterator(BackendQueryHolder<B> backendQueryHolder) {
            super(0x7FFFFFFE, backendQueryHolder.getBackendQuery().getLimit());
            this.backendQuery = backendQueryHolder.getBackendQuery();
            this.executionInfo = backendQueryHolder.getExecutionInfo();
            this.profiler = backendQueryHolder.getProfiler();
        }

        @Override
        public Iterator<R> getNewIterator(int newLimit) {
            if (!this.backendQuery.hasLimit() || newLimit > this.backendQuery.getLimit()) {
                this.backendQuery = this.backendQuery.updateLimit(newLimit);
            }
            return QueryProcessor.this.executor.execute(QueryProcessor.this.query, this.backendQuery, this.executionInfo, this.profiler);
        }
    }

    private final class PreSortingIterator
    implements CloseableIterator<R> {
        private final Iterator<R> iterator;

        private PreSortingIterator(BackendQueryHolder<B> backendQueryHolder) {
            ArrayList all = Lists.newArrayList(QueryProcessor.this.executor.execute(QueryProcessor.this.query, backendQueryHolder.getBackendQuery().updateLimit(1000000), backendQueryHolder.getExecutionInfo(), backendQueryHolder.getProfiler()));
            if (all.size() >= 1000000) {
                throw new QueryException("Could not execute query since pre-sorting requires fetching more than 1000000 elements. Consider rewriting the query to exploit sort orders");
            }
            all.sort(QueryProcessor.this.query.getSortOrder());
            this.iterator = all.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public R next() {
            return (JanusGraphElement)this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            CloseableIterator.closeIterator(this.iterator);
        }
    }
}

