/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.vertices;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.indextype.CompositeIndexTypeWrapper;
import org.janusgraph.graphdb.types.indextype.MixedIndexTypeWrapper;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.vertices.CacheVertex;

public class JanusGraphSchemaVertex
extends CacheVertex
implements SchemaSource {
    private String name = null;
    private TypeDefinitionMap definition = null;
    private ListMultimap<TypeDefinitionCategory, SchemaSource.Entry> outRelations = null;
    private ListMultimap<TypeDefinitionCategory, SchemaSource.Entry> inRelations = null;

    public JanusGraphSchemaVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public String name() {
        if (this.name == null) {
            JanusGraphVertexProperty p;
            if (this.isLoaded()) {
                StandardJanusGraphTx tx = this.tx();
                p = (JanusGraphVertexProperty)Iterables.getOnlyElement(RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.longId(), BaseKey.SchemaName, Direction.OUT), tx), null);
            } else {
                p = (JanusGraphVertexProperty)Iterables.getOnlyElement(((VertexCentricQueryBuilder)this.query().type(BaseKey.SchemaName)).properties(), null);
            }
            Preconditions.checkNotNull((Object)p, (String)"Could not find type for id: %s", (Object[])new Object[]{this.longId()});
            this.name = (String)p.value();
        }
        assert (this.name != null);
        return JanusGraphSchemaCategory.getName(this.name);
    }

    @Override
    protected Vertex getVertexLabelInternal() {
        return null;
    }

    @Override
    public TypeDefinitionMap getDefinition() {
        TypeDefinitionMap def = this.definition;
        if (def == null) {
            Iterable<JanusGraphRelation> ps;
            def = new TypeDefinitionMap();
            if (this.isLoaded()) {
                StandardJanusGraphTx tx = this.tx();
                ps = RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.longId(), BaseKey.SchemaDefinitionProperty, Direction.OUT), tx);
            } else {
                ps = ((VertexCentricQueryBuilder)this.query().type(BaseKey.SchemaDefinitionProperty)).properties();
            }
            for (JanusGraphVertexProperty property : ps) {
                TypeDefinitionDescription desc = (TypeDefinitionDescription)property.valueOrNull(BaseKey.SchemaDefinitionDesc);
                Preconditions.checkArgument((desc != null && desc.getCategory().isProperty() ? 1 : 0) != 0);
                def.setValue(desc.getCategory(), property.value());
            }
            assert (def.size() > 0);
            this.definition = def;
        }
        assert (def != null);
        return def;
    }

    @Override
    public Iterable<SchemaSource.Entry> getRelated(TypeDefinitionCategory def, Direction dir) {
        ImmutableListMultimap relations;
        assert (dir == Direction.OUT || dir == Direction.IN);
        Object object = relations = dir == Direction.OUT ? this.outRelations : this.inRelations;
        if (relations == null) {
            Iterable<JanusGraphRelation> edges;
            ImmutableListMultimap.Builder b = ImmutableListMultimap.builder();
            if (this.isLoaded()) {
                StandardJanusGraphTx tx = this.tx();
                edges = RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.longId(), BaseLabel.SchemaDefinitionEdge, dir), tx);
            } else {
                edges = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().type(BaseLabel.SchemaDefinitionEdge)).direction(dir)).edges();
            }
            for (JanusGraphEdge edge : edges) {
                JanusGraphVertex oth = edge.vertex(dir.opposite());
                assert (oth instanceof JanusGraphSchemaVertex);
                TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.valueOrNull(BaseKey.SchemaDefinitionDesc);
                Object modifier = null;
                if (desc.getCategory().hasDataType()) {
                    assert (desc.getModifier() != null && desc.getModifier().getClass().equals(desc.getCategory().getDataType()));
                    modifier = desc.getModifier();
                }
                b.put((Object)desc.getCategory(), (Object)new SchemaSource.Entry((JanusGraphSchemaVertex)oth, modifier));
            }
            relations = b.build();
            if (dir == Direction.OUT) {
                this.outRelations = relations;
            } else {
                this.inRelations = relations;
            }
        }
        assert (relations != null);
        return relations.get((Object)def);
    }

    @Override
    public void resetCache() {
        this.name = null;
        this.definition = null;
        this.outRelations = null;
        this.inRelations = null;
    }

    public Iterable<JanusGraphEdge> getEdges(TypeDefinitionCategory def, Direction dir) {
        return this.getEdges(def, dir, null);
    }

    public Iterable<JanusGraphEdge> getEdges(TypeDefinitionCategory def, Direction dir, JanusGraphSchemaVertex other) {
        JanusGraphVertexQuery query = (JanusGraphVertexQuery)((VertexCentricQueryBuilder)this.query().type(BaseLabel.SchemaDefinitionEdge)).direction(dir);
        if (other != null) {
            query.adjacent(other);
        }
        return Iterables.filter(query.edges(), edge -> {
            TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.valueOrNull(BaseKey.SchemaDefinitionDesc);
            return desc.getCategory() == def;
        });
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public SchemaStatus getStatus() {
        return this.getDefinition().getValue(TypeDefinitionCategory.STATUS, SchemaStatus.class);
    }

    @Override
    public IndexType asIndexType() {
        Preconditions.checkArgument((boolean)this.getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX), (String)"Schema vertex is not a type vertex: [%s,%s]", (Object[])new Object[]{this.longId(), this.name()});
        if (((Boolean)this.getDefinition().getValue(TypeDefinitionCategory.INTERNAL_INDEX)).booleanValue()) {
            return new CompositeIndexTypeWrapper(this);
        }
        return new MixedIndexTypeWrapper(this);
    }
}

