/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql.TermType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AsciiType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.FloatType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.IntegerType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LexicalUUIDType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import java.nio.ByteBuffer;
import java.util.List;

public class Term {
    private final String text;
    private final TermType type;
    private Integer bindIndex = -1;

    public Term(String text, TermType type) {
        this.text = text == null ? "" : text;
        this.type = type;
    }

    public Term(String text, int type) {
        this(text == null ? "" : text, TermType.forInt(type));
    }

    public Term(long value, TermType type) {
        this(String.valueOf(value), type);
    }

    protected Term() {
        this("", TermType.STRING);
    }

    public Term(String text, int type, int index) {
        this(text, type);
        this.bindIndex = index;
    }

    public String getText() {
        return this.text;
    }

    public ByteBuffer getByteBuffer(AbstractType<?> validator, List<ByteBuffer> variables) throws InvalidRequestException {
        try {
            if (!this.isBindMarker()) {
                return validator.fromStringCQL2(this.text);
            }
            if (this.bindIndex == null) {
                throw new AssertionError((Object)"a marker Term was encountered with no index value");
            }
            return variables.get(this.bindIndex);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public ByteBuffer getByteBuffer() throws InvalidRequestException {
        switch (this.type) {
            case STRING: {
                return AsciiType.instance.fromString(this.text);
            }
            case INTEGER: {
                return IntegerType.instance.fromString(this.text);
            }
            case UUID: {
                return LexicalUUIDType.instance.fromString(this.text);
            }
            case FLOAT: {
                return FloatType.instance.fromString(this.text);
            }
        }
        return null;
    }

    public TermType getType() {
        return this.type;
    }

    public String toString() {
        return String.format("Term(%s, type=%s)", new Object[]{this.getText(), this.type});
    }

    public boolean isBindMarker() {
        return this.type == TermType.QMARK;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        if (this.type == TermType.QMARK) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return this.type == other.type;
    }
}

