/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Row {
    public static final RowSerializer serializer = new RowSerializer();
    public final DecoratedKey key;
    public final ColumnFamily cf;

    public Row(DecoratedKey key, ColumnFamily cf) {
        assert (key != null);
        this.key = key;
        this.cf = cf;
    }

    public Row(ByteBuffer key, ColumnFamily updates) {
        this(StorageService.getPartitioner().decorateKey(key), updates);
    }

    public String toString() {
        return "Row(key=" + this.key + ", cf=" + this.cf + ')';
    }

    public int getLiveCount(IDiskAtomFilter filter, long now) {
        return this.cf == null ? 0 : filter.getLiveCount(this.cf, now);
    }

    public static class RowSerializer
    implements IVersionedSerializer<Row> {
        @Override
        public void serialize(Row row, DataOutput out, int version) throws IOException {
            ByteBufferUtil.writeWithShortLength(row.key.key, out);
            ColumnFamily.serializer.serialize(row.cf, out, version);
        }

        public Row deserialize(DataInput in, int version, ColumnSerializer.Flag flag) throws IOException {
            return new Row(StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(in)), ColumnFamily.serializer.deserialize(in, flag, version));
        }

        @Override
        public Row deserialize(DataInput in, int version) throws IOException {
            return this.deserialize(in, version, ColumnSerializer.Flag.LOCAL);
        }

        @Override
        public long serializedSize(Row row, int version) {
            int keySize = row.key.key.remaining();
            return (long)(TypeSizes.NATIVE.sizeof((short)keySize) + keySize) + ColumnFamily.serializer.serializedSize(row.cf, TypeSizes.NATIVE, version);
        }
    }
}

