/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.IMeasurableMemory;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionTime;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.IndexHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ObjectSizes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RowIndexEntry
implements IMeasurableMemory {
    public static final Serializer serializer = new Serializer();
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    public int serializedSize() {
        int size = TypeSizes.NATIVE.sizeof(this.position) + TypeSizes.NATIVE.sizeof(this.promotedSize());
        if (this.isIndexed()) {
            List<IndexHelper.IndexInfo> index = this.columnsIndex();
            size = (int)((long)size + DeletionTime.serializer.serializedSize(this.deletionTime(), TypeSizes.NATIVE));
            size += TypeSizes.NATIVE.sizeof(index.size());
            for (IndexHelper.IndexInfo info : index) {
                size += info.serializedSize(TypeSizes.NATIVE);
            }
        }
        return size;
    }

    protected int promotedSize() {
        return 0;
    }

    public static RowIndexEntry create(long position, DeletionTime deletionTime, ColumnIndex index) {
        assert (index != null);
        assert (deletionTime != null);
        if (index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionTime, index.columnsIndex);
        }
        return new RowIndexEntry(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public List<IndexHelper.IndexInfo> columnsIndex() {
        return Collections.emptyList();
    }

    @Override
    public long memorySize() {
        return ObjectSizes.getFieldSize(TypeSizes.NATIVE.sizeof(this.position));
    }

    private static class IndexedEntry
    extends RowIndexEntry {
        private final DeletionTime deletionTime;
        private final List<IndexHelper.IndexInfo> columnsIndex;

        private IndexedEntry(long position, DeletionTime deletionTime, List<IndexHelper.IndexInfo> columnsIndex) {
            super(position);
            assert (deletionTime != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        public int promotedSize() {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            long size = DeletionTime.serializer.serializedSize(this.deletionTime, typeSizes);
            size += (long)typeSizes.sizeof(this.columnsIndex.size());
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += (long)info.serializedSize(typeSizes);
            }
            return Ints.checkedCast((long)size);
        }

        @Override
        public long memorySize() {
            long entrySize = 0L;
            for (IndexHelper.IndexInfo idx : this.columnsIndex) {
                entrySize += idx.memorySize();
            }
            return ObjectSizes.getSuperClassFieldSize(TypeSizes.NATIVE.sizeof(this.position)) + ObjectSizes.getFieldSize(ObjectSizes.getReferenceSize() + ObjectSizes.getReferenceSize()) + this.deletionTime.memorySize() + ObjectSizes.getArraySize(this.columnsIndex.size(), ObjectSizes.getReferenceSize()) + entrySize + 4L;
        }
    }

    public static class Serializer {
        public void serialize(RowIndexEntry rie, DataOutput out) throws IOException {
            out.writeLong(rie.position);
            out.writeInt(rie.promotedSize());
            if (rie.isIndexed()) {
                DeletionTime.serializer.serialize(rie.deletionTime(), out);
                out.writeInt(rie.columnsIndex().size());
                for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                    info.serialize(out);
                }
            }
        }

        public RowIndexEntry deserialize(DataInput in, Descriptor.Version version) throws IOException {
            long position = in.readLong();
            int size = in.readInt();
            if (size > 0) {
                DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                int entries = in.readInt();
                ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                for (int i = 0; i < entries; ++i) {
                    columnsIndex.add(IndexHelper.IndexInfo.deserialize(in));
                }
                return new IndexedEntry(position, deletionTime, columnsIndex);
            }
            return new RowIndexEntry(position);
        }

        public void skip(DataInput in) throws IOException {
            in.readLong();
            this.skipPromotedIndex(in);
        }

        public void skipPromotedIndex(DataInput in) throws IOException {
            int size = in.readInt();
            if (size <= 0) {
                return;
            }
            FileUtils.skipBytesFully(in, size);
        }
    }
}

