/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.filter;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowIndexEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnCounter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;

public interface IDiskAtomFilter {
    public OnDiskAtomIterator getColumnFamilyIterator(DecoratedKey var1, ColumnFamily var2);

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader var1, FileDataInput var2, DecoratedKey var3, RowIndexEntry var4);

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader var1, DecoratedKey var2);

    public void collectReducedColumns(ColumnFamily var1, Iterator<Column> var2, int var3, long var4);

    public Comparator<Column> getColumnComparator(AbstractType<?> var1);

    public boolean isReversed();

    public void updateColumnsLimit(int var1);

    public int getLiveCount(ColumnFamily var1, long var2);

    public ColumnCounter columnCounter(AbstractType<?> var1, long var2);

    public IDiskAtomFilter cloneShallow();

    public boolean maySelectPrefix(Comparator<ByteBuffer> var1, ByteBuffer var2);

    public boolean shouldInclude(SSTableReader var1);

    public static class Serializer
    implements IVersionedSerializer<IDiskAtomFilter> {
        public static Serializer instance = new Serializer();

        @Override
        public void serialize(IDiskAtomFilter filter, DataOutput out, int version) throws IOException {
            if (filter instanceof SliceQueryFilter) {
                out.writeByte(0);
                SliceQueryFilter.serializer.serialize((SliceQueryFilter)filter, out, version);
            } else {
                out.writeByte(1);
                NamesQueryFilter.serializer.serialize((NamesQueryFilter)filter, out, version);
            }
        }

        @Override
        public IDiskAtomFilter deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public IDiskAtomFilter deserialize(DataInput in, int version, AbstractType<?> comparator) throws IOException {
            byte type = in.readByte();
            if (type == 0) {
                return SliceQueryFilter.serializer.deserialize(in, version);
            }
            assert (type == 1);
            return NamesQueryFilter.serializer.deserialize(in, version, comparator);
        }

        @Override
        public long serializedSize(IDiskAtomFilter filter, int version) {
            int size = 1;
            size = filter instanceof SliceQueryFilter ? (int)((long)size + SliceQueryFilter.serializer.serializedSize((SliceQueryFilter)filter, version)) : (int)((long)size + NamesQueryFilter.serializer.serializedSize((NamesQueryFilter)filter, version));
            return size;
        }
    }
}

