/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.hadoop;

import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.AbstractColumnFamilyRecordWriter;
import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.ColumnFamilyOutputFormat;
import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.ConfigHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.HadoopCompat;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.Mutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.TException;

final class ColumnFamilyRecordWriter
extends AbstractColumnFamilyRecordWriter<ByteBuffer, List<Mutation>> {
    private final Map<Range, RangeClient> clients = new HashMap<Range, RangeClient>();

    ColumnFamilyRecordWriter(TaskAttemptContext context) {
        this(HadoopCompat.getConfiguration((JobContext)context));
        this.context = context;
    }

    ColumnFamilyRecordWriter(Configuration conf, Progressable progressable) {
        this(conf);
        this.progressable = progressable;
    }

    ColumnFamilyRecordWriter(Configuration conf) {
        super(conf);
    }

    @Override
    public void close() throws IOException {
        IOException clientException = null;
        for (RangeClient client : this.clients.values()) {
            try {
                client.close();
            }
            catch (IOException e) {
                clientException = e;
            }
        }
        if (clientException != null) {
            throw clientException;
        }
    }

    public void write(ByteBuffer keybuff, List<Mutation> value) throws IOException {
        Range<Token> range = this.ringCache.getRange(keybuff);
        RangeClient client = this.clients.get(range);
        if (client == null) {
            client = new RangeClient(this.ringCache.getEndpoint(range));
            client.start();
            this.clients.put(range, client);
        }
        for (Mutation amut : value) {
            client.put(Pair.create(keybuff, amut));
        }
        if (this.progressable != null) {
            this.progressable.progress();
        }
        if (this.context != null) {
            HadoopCompat.progress(this.context);
        }
    }

    public class RangeClient
    extends AbstractColumnFamilyRecordWriter.AbstractRangeClient<Pair<ByteBuffer, Mutation>> {
        public final String columnFamily;

        public RangeClient(List<InetAddress> endpoints) {
            super(endpoints);
            this.columnFamily = ConfigHelper.getOutputColumnFamily(ColumnFamilyRecordWriter.this.conf);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block6: while (this.run || !this.queue.isEmpty()) {
                try {
                    mutation = (Pair)this.queue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                batch = new HashMap<T1, Map<String, ArrayList<E>>>();
                while (mutation != null) {
                    subBatch = (Map<String, ArrayList<E>>)batch.get(mutation.left);
                    if (subBatch == null) {
                        subBatch = Collections.singletonMap(this.columnFamily, new ArrayList<E>());
                        batch.put(mutation.left, subBatch);
                    }
                    ((List)subBatch.get(this.columnFamily)).add(mutation.right);
                    if ((long)batch.size() >= ColumnFamilyRecordWriter.this.batchThreshold) break;
                    mutation = (Pair)this.queue.poll();
                }
                iter = this.endpoints.iterator();
                while (true) {
                    try {
                        this.client.batch_mutate(batch, ColumnFamilyRecordWriter.this.consistencyLevel);
                        continue block6;
                    }
                    catch (Exception e) {
                        this.closeInternal();
                        if (!iter.hasNext()) {
                            this.lastException = new IOException(e);
                            break block6;
                        }
                        try {
                            address = (InetAddress)iter.next();
                            host = address.getHostName();
                            port = ConfigHelper.getOutputRpcPort(ColumnFamilyRecordWriter.this.conf);
                            this.client = ColumnFamilyOutputFormat.createAuthenticatedClient(host, port, ColumnFamilyRecordWriter.this.conf);
                            continue;
                        }
                        catch (Exception e) {
                            this.closeInternal();
                            if (!(e instanceof TException) || !iter.hasNext()) ** break;
                            continue;
                            this.lastException = new IOException(e);
                            break block6;
                        }
                    }
                    break;
                }
            }
        }
    }
}

