/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.compress;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.ICompressor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;

public class LZ4Compressor
implements ICompressor {
    private static final int INTEGER_BYTES = 4;
    @VisibleForTesting
    public static final LZ4Compressor instance = new LZ4Compressor();
    private final net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4Decompressor decompressor;

    public static LZ4Compressor create(Map<String, String> args) {
        return instance;
    }

    private LZ4Compressor() {
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.decompressor();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return 4 + this.compressor.maxCompressedLength(chunkLength);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, ICompressor.WrappedArray output, int outputOffset) throws IOException {
        byte[] dest = output.buffer;
        dest[outputOffset] = (byte)inputLength;
        dest[outputOffset + 1] = (byte)(inputLength >>> 8);
        dest[outputOffset + 2] = (byte)(inputLength >>> 16);
        dest[outputOffset + 3] = (byte)(inputLength >>> 24);
        int maxCompressedLength = this.compressor.maxCompressedLength(inputLength);
        try {
            return 4 + this.compressor.compress(input, inputOffset, inputLength, dest, outputOffset + 4, maxCompressedLength);
        }
        catch (LZ4Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        int compressedLength;
        int decompressedLength = input[inputOffset] & 0xFF | (input[inputOffset + 1] & 0xFF) << 8 | (input[inputOffset + 2] & 0xFF) << 16 | (input[inputOffset + 3] & 0xFF) << 24;
        try {
            compressedLength = this.decompressor.decompress(input, inputOffset + 4, output, outputOffset, decompressedLength);
        }
        catch (LZ4Exception e) {
            throw new IOException(e);
        }
        if (compressedLength != inputLength - 4) {
            throw new IOException("Compressed lengths mismatch");
        }
        return decompressedLength;
    }

    @Override
    public Set<String> supportedOptions() {
        return new HashSet<String>(Arrays.asList("crc_check_chance"));
    }
}

