/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Checksum;

public class ChecksummedOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Checksum checksum;

    public ChecksummedOutputStream(OutputStream out, Checksum checksum) {
        this.out = out;
        this.checksum = checksum;
    }

    public void resetChecksum() {
        this.checksum.reset();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.checksum.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.checksum.update(b, off, len);
    }
}

