/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.Memory;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryOutputStream
extends OutputStream {
    private final Memory mem;
    private int position = 0;

    public MemoryOutputStream(Memory mem) {
        this.mem = mem;
    }

    @Override
    public void write(int b) {
        this.mem.setByte(this.position++, (byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mem.setBytes(this.position, b, off, len);
        this.position += len;
    }

    public int position() {
        return this.position;
    }
}

