/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.RepairJobDesc;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.StreamingRepairTask;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.Validator;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.RepairMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.SyncRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.ValidationRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ActiveRepairService;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    @Override
    public void doVerb(MessageIn<RepairMessage> message, int id) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        switch (((RepairMessage)message.payload).messageType) {
            case VALIDATION_REQUEST: {
                ValidationRequest validationRequest = (ValidationRequest)message.payload;
                ColumnFamilyStore store = Keyspace.open(desc.keyspace).getColumnFamilyStore(desc.columnFamily);
                Validator validator = new Validator(desc, message.from, validationRequest.gcBefore);
                CompactionManager.instance.submitValidation(store, validator);
                break;
            }
            case SYNC_REQUEST: {
                SyncRequest request = (SyncRequest)message.payload;
                StreamingRepairTask task = new StreamingRepairTask(desc, request);
                task.run();
                break;
            }
            default: {
                ActiveRepairService.instance.handleMessage(message.from, (RepairMessage)message.payload);
            }
        }
    }
}

