/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.WriteType;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.IEndpointSnitch;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.NetworkTopologyStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.AbstractWriteResponseHandler;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DatacenterSyncWriteResponseHandler
extends AbstractWriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final NetworkTopologyStrategy strategy;
    private final HashMap<String, AtomicInteger> responses = new HashMap();
    private final AtomicInteger acks = new AtomicInteger(0);

    public DatacenterSyncWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Keyspace keyspace, Runnable callback, WriteType writeType) {
        super(keyspace, naturalEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
        assert (consistencyLevel == ConsistencyLevel.EACH_QUORUM);
        this.strategy = (NetworkTopologyStrategy)keyspace.getReplicationStrategy();
        for (String dc : this.strategy.getDatacenters()) {
            int rf = this.strategy.getReplicationFactor(dc);
            this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
        }
        for (InetAddress pending : pendingEndpoints) {
            this.responses.get(snitch.getDatacenter(pending)).incrementAndGet();
        }
    }

    @Override
    public void response(MessageIn message) {
        String dataCenter = message == null ? DatabaseDescriptor.getLocalDataCenter() : snitch.getDatacenter(message.from);
        this.responses.get(dataCenter).getAndDecrement();
        this.acks.incrementAndGet();
        for (AtomicInteger i : this.responses.values()) {
            if (i.get() <= 0) continue;
            return;
        }
        this.signal();
    }

    @Override
    protected int ackCount() {
        return this.acks.get();
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

