/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.QueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.AsyncOneResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.AbstractRowResolver;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.DigestMismatchException;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.CloseableIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RowDataResolver
extends AbstractRowResolver {
    private int maxLiveCount = 0;
    public List<AsyncOneResponse> repairResults = Collections.emptyList();
    private final IDiskAtomFilter filter;
    private final long timestamp;

    public RowDataResolver(String keyspaceName, ByteBuffer key, IDiskAtomFilter qFilter, long timestamp) {
        super(key, keyspaceName);
        this.filter = qFilter;
        this.timestamp = timestamp;
    }

    @Override
    public Row resolve() throws DigestMismatchException {
        ColumnFamily resolved;
        if (logger.isDebugEnabled()) {
            logger.debug("resolving " + this.replies.size() + " responses");
        }
        long start = System.nanoTime();
        if (this.replies.size() > 1) {
            ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>(this.replies.size());
            ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.replies.size());
            for (MessageIn message : this.replies) {
                ReadResponse response = (ReadResponse)message.payload;
                ColumnFamily cf = response.row().cf;
                assert (!response.isDigestQuery()) : "Received digest response to repair read from " + message.from;
                versions.add(cf);
                endpoints.add(message.from);
                int liveCount = cf == null ? 0 : this.filter.getLiveCount(cf, this.timestamp);
                if (liveCount <= this.maxLiveCount) continue;
                this.maxLiveCount = liveCount;
            }
            resolved = RowDataResolver.resolveSuperset(versions, this.timestamp);
            if (logger.isDebugEnabled()) {
                logger.debug("versions merged");
            }
            if (resolved != null) {
                this.repairResults = RowDataResolver.scheduleRepairs(resolved, this.keyspaceName, this.key, versions, endpoints);
            }
        } else {
            resolved = ((ReadResponse)((MessageIn)this.replies.iterator().next()).payload).row().cf;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        return new Row(this.key, resolved);
    }

    public static List<AsyncOneResponse> scheduleRepairs(ColumnFamily resolved, String keyspaceName, DecoratedKey key, List<ColumnFamily> versions, List<InetAddress> endpoints) {
        ArrayList<AsyncOneResponse> results = new ArrayList<AsyncOneResponse>(versions.size());
        for (int i = 0; i < versions.size(); ++i) {
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            RowMutation rowMutation = new RowMutation(keyspaceName, key.key, diffCf);
            Tracing.trace("Sending read-repair-mutation to {}", endpoints.get(i));
            MessageOut<RowMutation> repairMessage = rowMutation.createMessage(MessagingService.Verb.READ_REPAIR);
            results.add(MessagingService.instance().sendRR(repairMessage, endpoints.get(i)));
        }
        return results;
    }

    static ColumnFamily resolveSuperset(Iterable<ColumnFamily> versions, long now) {
        assert (Iterables.size(versions) > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            if (resolved == null) {
                resolved = cf.cloneMeShallow();
                continue;
            }
            resolved.delete(cf);
        }
        if (resolved == null) {
            return null;
        }
        QueryFilter filter = new QueryFilter(null, resolved.metadata().cfName, new IdentityQueryFilter(), now);
        ArrayList<CloseableIterator<Column>> iters = new ArrayList<CloseableIterator<Column>>();
        for (ColumnFamily version : versions) {
            if (version == null) continue;
            iters.add(FBUtilities.closeableIterator(version.iterator()));
        }
        filter.collateColumns(resolved, iters, Integer.MIN_VALUE);
        return ColumnFamilyStore.removeDeleted(resolved, Integer.MIN_VALUE);
    }

    @Override
    public Row getData() {
        return ((ReadResponse)((MessageIn)this.replies.iterator().next()).payload).row();
    }

    @Override
    public boolean isDataPresent() {
        return !this.replies.isEmpty();
    }

    public int getMaxLiveCount() {
        return this.maxLiveCount;
    }
}

