/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQLStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ErrorMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MD5Digest;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.netty.buffer.ChannelBuffer;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ChannelBuffer body, int version) {
            byte[] id = CBUtil.readBytes(body);
            if (version == 1) {
                List<ByteBuffer> values = CBUtil.readValueList(body);
                ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
                return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.fromProtocolV1(consistency, values));
            }
            return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(ExecuteMessage msg, ChannelBuffer dest, int version) {
            CBUtil.writeBytes(msg.statementId.bytes, dest);
            if (version == 1) {
                CBUtil.writeValueList(msg.options.getValues(), dest);
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(ExecuteMessage msg, int version) {
            int size = 0;
            size += CBUtil.sizeOfBytes(msg.statementId.bytes);
            if (version == 1) {
                size += CBUtil.sizeOfValueList(msg.options.getValues());
                size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency());
            } else {
                size += QueryOptions.codec.encodedSize(msg.options, version);
            }
            return size;
        }
    };
    public final MD5Digest statementId;
    public final QueryOptions options;

    public ExecuteMessage(MD5Digest statementId, QueryOptions options) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            state.getClientState();
            QueryHandler handler = ClientState.getCQLQueryHandler();
            CQLStatement statement = handler.getPrepared(this.statementId);
            if (statement == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (this.options.getPageSize() > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
                }
                Tracing.instance.begin("Execute CQL3 prepared query", (Map<String, String>)builder.build());
            }
            ResultMessage response = handler.processPrepared(statement, state, this.options);
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.options.getValues().size() + " values at consistency " + (Object)((Object)this.options.getConsistency());
    }
}

