/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.astyanax.connectionpool.BadHostDetector;
import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.HostDownException;
import com.netflix.astyanax.connectionpool.exceptions.InterruptedOperationException;
import com.netflix.astyanax.connectionpool.exceptions.IsDeadConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.PoolTimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.TimeoutException;
import com.netflix.astyanax.connectionpool.exceptions.UnknownException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHostConnectionPool<CL>
implements HostConnectionPool<CL> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHostConnectionPool.class);
    private static final int MAX_PRIME_CONNECTIONS_RETRY_ATTEMPT = 2;
    private static final int PRIME_CONNECTION_DELAY = 100;
    private static final AtomicLong poolIdCounter = new AtomicLong(0L);
    private final long id = poolIdCounter.incrementAndGet();
    private final BlockingQueue<Connection<CL>> availableConnections;
    private final AtomicInteger activeCount = new AtomicInteger(0);
    private final AtomicInteger pendingConnections = new AtomicInteger(0);
    private final AtomicInteger blockedThreads = new AtomicInteger(0);
    private final AtomicInteger openConnections = new AtomicInteger(0);
    private final AtomicInteger failedOpenConnections = new AtomicInteger(0);
    private final AtomicInteger closedConnections = new AtomicInteger(0);
    private final AtomicLong borrowedCount = new AtomicLong(0L);
    private final AtomicLong returnedCount = new AtomicLong(0L);
    private final AtomicInteger connectAttempt = new AtomicInteger(0);
    private final AtomicInteger markedDownCount = new AtomicInteger(0);
    private final AtomicInteger errorsSinceLastSuccess = new AtomicInteger(0);
    private final ConnectionFactory<CL> factory;
    private final Host host;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final AtomicBoolean isReconnecting = new AtomicBoolean(false);
    private final ScheduledExecutorService executor;
    private final RetryBackoffStrategy.Instance retryContext;
    private final BadHostDetector.Instance badHostDetector;
    private final LatencyScoreStrategy.Instance latencyStrategy;
    private final Listener<CL> listener;
    private final ConnectionPoolMonitor monitor;
    protected final ConnectionPoolConfiguration config;

    public SimpleHostConnectionPool(Host host, ConnectionFactory<CL> factory, ConnectionPoolMonitor monitor, ConnectionPoolConfiguration config, Listener<CL> listener) {
        this.host = host;
        this.config = config;
        this.factory = factory;
        this.listener = listener;
        this.retryContext = config.getRetryBackoffStrategy().createInstance();
        this.latencyStrategy = config.getLatencyScoreStrategy().createInstance();
        this.badHostDetector = config.getBadHostDetector().createInstance();
        this.monitor = monitor;
        this.availableConnections = new LinkedBlockingQueue<Connection<CL>>();
        this.executor = config.getHostReconnectExecutor();
        Preconditions.checkNotNull((Object)config.getHostReconnectExecutor(), (Object)"HostReconnectExecutor cannot be null");
    }

    @Override
    public int primeConnections(int numConnections) throws ConnectionException, InterruptedException {
        if (this.isReconnecting()) {
            throw new HostDownException("Can't prime connections on downed host.");
        }
        int remaining = Math.min(numConnections, this.config.getMaxConnsPerHost() - this.getActiveConnectionCount());
        int opened = 0;
        Exception lastException = null;
        int i = 0;
        while (opened < remaining && i < 2) {
            try {
                this.reconnect();
                ++opened;
            }
            catch (Exception e) {
                lastException = e;
                Thread.sleep(100L);
                ++i;
            }
        }
        if (remaining > 0 && opened == 0) {
            this.markAsDown(null);
            throw new HostDownException("Failed to prime connections", lastException);
        }
        return opened;
    }

    @Override
    public Connection<CL> borrowConnection(int timeout) throws ConnectionException {
        Connection<CL> connection = null;
        long startTime = System.currentTimeMillis();
        try {
            connection = (Connection<CL>)this.availableConnections.poll();
            if (connection != null) {
                Connection<CL> connection2 = connection;
                return connection2;
            }
            boolean isOpenning = this.tryOpenAsync();
            if (timeout > 0) {
                Connection<CL> connection3 = connection = this.waitForConnection(isOpenning ? this.config.getConnectTimeout() : timeout);
                return connection3;
            }
            throw new PoolTimeoutException("Fast fail waiting for connection from pool").setHost(this.getHost()).setLatency(System.currentTimeMillis() - startTime);
        }
        finally {
            if (connection != null) {
                this.borrowedCount.incrementAndGet();
                this.monitor.incConnectionBorrowed(this.host, System.currentTimeMillis() - startTime);
            }
        }
    }

    private Connection<CL> waitForConnection(int timeout) throws ConnectionException {
        Connection<CL> connection = null;
        long startTime = System.currentTimeMillis();
        try {
            this.blockedThreads.incrementAndGet();
            connection = this.availableConnections.poll(timeout, TimeUnit.MILLISECONDS);
            if (connection != null) {
                Connection<CL> connection2 = connection;
                return connection2;
            }
            try {
                throw new PoolTimeoutException("Timed out waiting for connection").setHost(this.getHost()).setLatency(System.currentTimeMillis() - startTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedOperationException("Thread interrupted waiting for connection").setHost(this.getHost()).setLatency(System.currentTimeMillis() - startTime);
            }
        }
        finally {
            this.blockedThreads.decrementAndGet();
        }
    }

    @Override
    public boolean returnConnection(Connection<CL> connection) {
        this.returnedCount.incrementAndGet();
        this.monitor.incConnectionReturned(this.host);
        ConnectionException ce = connection.getLastException();
        if (ce != null && ce instanceof IsDeadConnectionException) {
            this.noteError(ce);
            this.internalCloseConnection(connection);
            return true;
        }
        this.errorsSinceLastSuccess.set(0);
        if (this.activeCount.get() <= this.config.getMaxConnsPerHost()) {
            this.availableConnections.add(connection);
            if (this.isShutdown()) {
                this.discardIdleConnections();
                return true;
            }
        } else {
            this.internalCloseConnection(connection);
            return true;
        }
        return false;
    }

    @Override
    public boolean closeConnection(Connection<CL> connection) {
        this.returnedCount.incrementAndGet();
        this.monitor.incConnectionReturned(this.host);
        this.internalCloseConnection(connection);
        return true;
    }

    private void internalCloseConnection(Connection<CL> connection) {
        try {
            this.closedConnections.incrementAndGet();
            connection.close();
        }
        finally {
            this.activeCount.decrementAndGet();
        }
    }

    private void noteError(ConnectionException reason) {
        if (this.errorsSinceLastSuccess.incrementAndGet() > 3) {
            this.markAsDown(reason);
        }
    }

    @Override
    public void markAsDown(ConnectionException reason) {
        if (this.isReconnecting.compareAndSet(false, true)) {
            this.markedDownCount.incrementAndGet();
            if (reason != null && !(reason instanceof TimeoutException)) {
                this.discardIdleConnections();
            }
            this.listener.onHostDown(this);
            this.monitor.onHostDown(this.getHost(), reason);
            this.retryContext.begin();
            try {
                long delay = this.retryContext.getNextDelay();
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("RetryService : " + SimpleHostConnectionPool.this.host.getName());
                        try {
                            if (SimpleHostConnectionPool.this.activeCount.get() == 0) {
                                SimpleHostConnectionPool.this.reconnect();
                            }
                            try {
                                SimpleHostConnectionPool.this.retryContext.success();
                                if (SimpleHostConnectionPool.this.isReconnecting.compareAndSet(true, false)) {
                                    SimpleHostConnectionPool.this.monitor.onHostReactivated(SimpleHostConnectionPool.this.host, SimpleHostConnectionPool.this);
                                    SimpleHostConnectionPool.this.listener.onHostUp(SimpleHostConnectionPool.this);
                                }
                            }
                            catch (Throwable t) {
                                LOG.error("Error reconnecting client", t);
                            }
                            return;
                        }
                        catch (Throwable t) {
                            if (!SimpleHostConnectionPool.this.isShutdown()) {
                                long delay = SimpleHostConnectionPool.this.retryContext.getNextDelay();
                                SimpleHostConnectionPool.this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
                            }
                            return;
                        }
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.error("Failed to schedule retry task for " + this.host.getHostName(), (Throwable)e);
            }
        }
    }

    private void reconnect() throws Exception {
        try {
            if (this.activeCount.get() < this.config.getMaxConnsPerHost()) {
                if (this.activeCount.incrementAndGet() <= this.config.getMaxConnsPerHost()) {
                    this.connectAttempt.incrementAndGet();
                    Connection<CL> connection = this.factory.createConnection(this);
                    connection.open();
                    this.errorsSinceLastSuccess.set(0);
                    this.availableConnections.add(connection);
                    this.openConnections.incrementAndGet();
                } else {
                    this.activeCount.decrementAndGet();
                }
            }
        }
        catch (ConnectionException e) {
            this.failedOpenConnections.incrementAndGet();
            this.activeCount.decrementAndGet();
            this.noteError(e);
            throw e;
        }
        catch (Throwable t) {
            this.failedOpenConnections.incrementAndGet();
            this.activeCount.decrementAndGet();
            UnknownException ce = new UnknownException(t);
            this.noteError(ce);
            throw ce;
        }
    }

    @Override
    public void shutdown() {
        this.isReconnecting.set(true);
        this.isShutdown.set(true);
        this.discardIdleConnections();
        this.config.getLatencyScoreStrategy().removeInstance(this.latencyStrategy);
        this.config.getBadHostDetector().removeInstance(this.badHostDetector);
    }

    /*
     * Exception decompiling
     */
    private boolean tryOpenAsync() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isReconnecting() {
        return this.isReconnecting.get();
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public int getActiveConnectionCount() {
        return this.activeCount.get();
    }

    @Override
    public int getIdleConnectionCount() {
        return this.availableConnections.size();
    }

    @Override
    public int getPendingConnectionCount() {
        return this.pendingConnections.get();
    }

    @Override
    public int getBlockedThreadCount() {
        return this.blockedThreads.get();
    }

    @Override
    public int getOpenedConnectionCount() {
        return this.openConnections.get();
    }

    @Override
    public int getFailedOpenConnectionCount() {
        return this.failedOpenConnections.get();
    }

    @Override
    public int getClosedConnectionCount() {
        return this.closedConnections.get();
    }

    @Override
    public int getConnectAttemptCount() {
        return this.connectAttempt.get();
    }

    @Override
    public int getBusyConnectionCount() {
        return this.getActiveConnectionCount() - this.getIdleConnectionCount() - this.getPendingConnectionCount();
    }

    @Override
    public double getScore() {
        return this.latencyStrategy.getScore();
    }

    @Override
    public void addLatencySample(long latency, long now) {
        this.latencyStrategy.addSample(latency);
    }

    @Override
    public int getErrorsSinceLastSuccess() {
        return this.errorsSinceLastSuccess.get();
    }

    private void discardIdleConnections() {
        ArrayList connections = Lists.newArrayList();
        this.availableConnections.drainTo(connections);
        this.activeCount.addAndGet(-connections.size());
        for (Connection connection : connections) {
            try {
                this.closedConnections.incrementAndGet();
                connection.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String toString() {
        int idle = this.getIdleConnectionCount();
        int open = this.getActiveConnectionCount();
        return "SimpleHostConnectionPool[" + "host=" + this.host + "-" + this.id + ",down=" + this.markedDownCount.get() + ",active=" + !this.isShutdown() + ",recon=" + this.isReconnecting() + ",connections(" + "open=" + open + ",idle=" + idle + ",busy=" + (open - idle) + ",closed=" + this.closedConnections.get() + ",failed=" + this.failedOpenConnections.get() + ")" + ",borrow=" + this.borrowedCount.get() + ",return=" + this.returnedCount.get() + ",blocked=" + this.getBlockedThreadCount() + ",pending=" + this.getPendingConnectionCount() + ",score=" + TimeUnit.MILLISECONDS.convert((long)this.getScore(), TimeUnit.NANOSECONDS) + "]";
    }

    @Override
    public boolean isActive() {
        return !this.isShutdown.get();
    }

    public static interface Listener<CL> {
        public void onHostDown(HostConnectionPool<CL> var1);

        public void onHostUp(HostConnectionPool<CL> var1);
    }
}

