/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"ClassificationSearchProcessor");
    private final AtlasIndexQuery indexQuery;
    private final AtlasIndexQuery classificationIndexQuery;
    private final AtlasGraphQuery tagGraphQueryWithAttributes;
    private final Predicate traitPredicate;
    private final Predicate isEntityPredicate;
    private Predicate activePredicate;
    private boolean whiteSpaceFilter = false;

    public ClassificationSearchProcessor(SearchContext context) {
        super(context);
        String indexQueryString;
        StringBuilder queryString;
        SearchParameters.FilterCriteria filterCriteria = context.getSearchParameters().getTagFilters();
        HashSet<String> indexAttributes = new HashSet<String>();
        HashSet<String> graphAttributes = new HashSet<String>();
        HashSet<String> allAttributes = new HashSet<String>();
        Set<String> typeAndSubTypes = context.getClassificationTypeNames();
        String typeAndSubTypesQryStr = context.getClassificationTypesQryStr();
        boolean isWildcardSearch = context.isWildCardSearch();
        Set<AtlasClassificationType> classificationTypes = context.getClassificationTypes();
        this.processSearchAttributes(classificationTypes, filterCriteria, indexAttributes, graphAttributes, allAttributes);
        boolean useIndexSearchForEntity = (CollectionUtils.isNotEmpty(classificationTypes) || isWildcardSearch) && !context.hasAttributeFilter(filterCriteria) && typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TAGS;
        boolean useIndexSearchForClassification = CollectionUtils.isNotEmpty(classificationTypes) && classificationTypes.iterator().next() != SearchContext.MATCH_ALL_NOT_CLASSIFIED && !isWildcardSearch && typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TAGS && CollectionUtils.isNotEmpty(indexAttributes) && this.canApplyIndexFilter(classificationTypes, filterCriteria, false);
        boolean useGraphSearchForClassification = CollectionUtils.isNotEmpty(classificationTypes) && classificationTypes.iterator().next() != SearchContext.MATCH_ALL_NOT_CLASSIFIED && !isWildcardSearch && CollectionUtils.isNotEmpty(graphAttributes);
        this.traitPredicate = this.buildTraitPredict(classificationTypes);
        this.isEntityPredicate = SearchPredicateUtil.generateIsEntityVertexPredicate(context.getTypeRegistry());
        if (context.getSearchParameters().getExcludeDeletedEntities()) {
            this.activePredicate = SearchPredicateUtil.getEQPredicateGenerator().generatePredicate(Constants.STATE_PROPERTY_KEY, AtlasEntity.Status.ACTIVE.name(), String.class);
        }
        Predicate attributePredicate = null;
        Predicate typeNamePredicate = null;
        AtlasGraph graph = context.getGraph();
        if (useIndexSearchForEntity) {
            queryString = new StringBuilder();
            this.graphIndexQueryBuilder.addActiveStateQueryFilter(queryString);
            if (isWildcardSearch) {
                this.graphIndexQueryBuilder.addClassificationTypeFilter(queryString);
            } else if (classificationTypes.iterator().next() == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
                this.graphIndexQueryBuilder.addClassificationFilterForBuiltInTypes(queryString);
            } else {
                this.graphIndexQueryBuilder.addClassificationAndSubTypesQueryFilter(queryString);
                this.whiteSpaceFilter = true;
            }
            indexQueryString = STRAY_AND_PATTERN.matcher(queryString).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.indexQuery = graph.indexQuery("vertex_index", indexQueryString);
            LOG.debug("Using query string  '{}'.", (Object)this.indexQuery);
        } else {
            this.indexQuery = null;
        }
        if (useIndexSearchForClassification) {
            queryString = new StringBuilder();
            this.graphIndexQueryBuilder.addActiveStateQueryFilter(queryString);
            this.graphIndexQueryBuilder.addTypeAndSubTypesQueryFilter(queryString, typeAndSubTypesQryStr);
            this.constructFilterQuery(queryString, classificationTypes, filterCriteria, indexAttributes);
            indexQueryString = STRAY_AND_PATTERN.matcher(queryString).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.classificationIndexQuery = graph.indexQuery("vertex_index", indexQueryString);
            typeNamePredicate = this.isClassificationRootType() ? null : SearchPredicateUtil.getINPredicateGenerator().generatePredicate("__typeName", typeAndSubTypes, String.class);
            attributePredicate = this.constructInMemoryPredicate(classificationTypes, filterCriteria, indexAttributes);
        } else {
            this.classificationIndexQuery = null;
        }
        if (useGraphSearchForClassification) {
            AtlasGraphQuery query = graph.query();
            if (!this.isClassificationRootType()) {
                query.in("__typeName", typeAndSubTypes);
            }
            this.tagGraphQueryWithAttributes = this.toGraphFilterQuery(classificationTypes, filterCriteria, allAttributes, query);
            typeNamePredicate = this.isClassificationRootType() ? null : SearchPredicateUtil.getINPredicateGenerator().generatePredicate("__typeName", typeAndSubTypes, String.class);
            attributePredicate = this.constructInMemoryPredicate(classificationTypes, filterCriteria, allAttributes);
        } else {
            this.tagGraphQueryWithAttributes = null;
        }
        if (typeNamePredicate != null) {
            Predicate predicate = this.inMemoryPredicate = this.inMemoryPredicate == null ? typeNamePredicate : PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, typeNamePredicate);
        }
        if (attributePredicate != null) {
            this.inMemoryPredicate = this.inMemoryPredicate == null ? attributePredicate : PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, attributePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ClassificationSearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("ClassificationSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int qryOffset;
            int limit = this.context.getSearchParameters().getLimit();
            Integer marker = this.context.getMarker();
            if (this.indexQuery == null) {
                marker = null;
            }
            int startIdx = marker != null ? marker.intValue() : this.context.getSearchParameters().getOffset();
            int resultIdx = qryOffset = marker != null ? marker : 0;
            HashSet<String> processedGuids = new HashSet<String>();
            LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap = new LinkedHashMap<Integer, AtlasVertex>();
            ArrayList<AtlasVertex> classificationVertices = new ArrayList<AtlasVertex>();
            String sortBy = this.context.getSearchParameters().getSortBy();
            SortOrder sortOrder = this.context.getSearchParameters().getSortOrder();
            while (ret.size() < limit) {
                offsetEntityVertexMap.clear();
                classificationVertices.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                boolean isLastResultPage = true;
                if (this.indexQuery != null) {
                    Iterator queryResult;
                    if (StringUtils.isNotEmpty((CharSequence)sortBy)) {
                        Order qrySortOrder = sortOrder == SortOrder.ASCENDING ? Order.asc : Order.desc;
                        queryResult = this.indexQuery.vertices(qryOffset, limit, sortBy, qrySortOrder);
                    } else {
                        queryResult = this.indexQuery.vertices(qryOffset, limit);
                    }
                    offsetEntityVertexMap = this.getVerticesFromIndexQueryResult(queryResult, offsetEntityVertexMap, qryOffset);
                    isLastResultPage = offsetEntityVertexMap.size() < limit;
                    offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.traitPredicate);
                    offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.isEntityPredicate);
                } else if (this.classificationIndexQuery != null) {
                    Iterator queryResult = this.classificationIndexQuery.vertices(qryOffset, limit);
                    this.getVerticesFromIndexQueryResult(queryResult, classificationVertices);
                    isLastResultPage = classificationVertices.size() < limit;
                    CollectionUtils.filter(classificationVertices, (Predicate)this.inMemoryPredicate);
                } else if (this.tagGraphQueryWithAttributes != null) {
                    Iterator<AtlasVertex> queryResult = this.tagGraphQueryWithAttributes.vertices(qryOffset, limit).iterator();
                    this.getVertices(queryResult, classificationVertices);
                    isLastResultPage = classificationVertices.size() < limit;
                    CollectionUtils.filter(classificationVertices, (Predicate)this.inMemoryPredicate);
                }
                if (CollectionUtils.isNotEmpty(classificationVertices)) {
                    int resultCount = 0;
                    for (AtlasVertex classificationVertex : classificationVertices) {
                        Iterable edges = classificationVertex.getEdges(AtlasEdgeDirection.IN, "classifiedAs");
                        for (AtlasEdge edge : edges) {
                            AtlasVertex entityVertex = edge.getOutVertex();
                            ++resultCount;
                            String guid = AtlasGraphUtilsV2.getIdFromVertex(entityVertex);
                            if (processedGuids.contains(guid)) continue;
                            offsetEntityVertexMap.put(qryOffset + resultCount - 1, entityVertex);
                            processedGuids.add(guid);
                        }
                    }
                }
                if (this.whiteSpaceFilter) {
                    offsetEntityVertexMap = this.filterWhiteSpaceClassification(offsetEntityVertexMap);
                }
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.isEntityPredicate);
                if (this.activePredicate != null) {
                    offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.activePredicate);
                }
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, offsetEntityVertexMap, marker);
                if (isLastResultPage) {
                    resultIdx = -2;
                    break;
                }
                qryOffset += limit;
            }
            if (marker != null) {
                this.nextOffset = resultIdx + 1;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ClassificationSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public LinkedHashMap<Integer, AtlasVertex> filter(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ClassificationSearchProcessor.filter({})", (Object)offsetEntityVertexMap.size());
        }
        if (this.inMemoryPredicate != null) {
            offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.traitPredicate);
            HashSet<String> processedGuids = new HashSet<String>();
            LinkedHashMap<Integer, AtlasVertex> matchEntityVertices = new LinkedHashMap<Integer, AtlasVertex>();
            if (MapUtils.isNotEmpty(offsetEntityVertexMap)) {
                block0: for (Map.Entry<Integer, AtlasVertex> offsetToEntity : offsetEntityVertexMap.entrySet()) {
                    AtlasVertex entityVertex = offsetToEntity.getValue();
                    Iterable edges = entityVertex.getEdges(AtlasEdgeDirection.OUT, "classifiedAs");
                    for (AtlasEdge edge : edges) {
                        String guid;
                        AtlasVertex classificationVertex = edge.getInVertex();
                        AtlasVertex matchVertex = (AtlasVertex)CollectionUtils.find(Collections.singleton(classificationVertex), (Predicate)this.inMemoryPredicate);
                        if (matchVertex == null || processedGuids.contains(guid = AtlasGraphUtilsV2.getIdFromVertex(entityVertex))) continue;
                        matchEntityVertices.put(offsetToEntity.getKey(), entityVertex);
                        processedGuids.add(guid);
                        continue block0;
                    }
                }
            }
            offsetEntityVertexMap.clear();
            offsetEntityVertexMap.putAll(matchEntityVertices);
        } else {
            offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.traitPredicate);
            offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.isEntityPredicate);
        }
        offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ClassificationSearchProcessor.filter(): ret.size()={}", (Object)offsetEntityVertexMap.size());
        }
        return offsetEntityVertexMap;
    }

    @Override
    public long getResultCount() {
        return this.indexQuery != null ? this.indexQuery.vertexTotals() : -1L;
    }
}

