/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GraphIndexQueryBuilder {
    SearchContext context;

    GraphIndexQueryBuilder(SearchContext context) {
        this.context = context;
    }

    void addClassificationTypeFilter(StringBuilder indexQuery) {
        if (indexQuery != null && CollectionUtils.isNotEmpty(this.context.getClassificationNames())) {
            String classificationNames = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(this.context.getClassificationNames(), (boolean)true);
            if (indexQuery.length() != 0) {
                indexQuery.append(" AND ");
            }
            indexQuery.append("(").append(SearchProcessor.INDEX_SEARCH_PREFIX).append('\"').append(Constants.CLASSIFICATION_NAMES_KEY).append('\"').append(':').append(classificationNames).append(" OR ").append(SearchProcessor.INDEX_SEARCH_PREFIX).append('\"').append(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY).append('\"').append(':').append(classificationNames).append(")");
        }
    }

    void addClassificationAndSubTypesQueryFilter(StringBuilder indexQuery) {
        if (indexQuery != null && CollectionUtils.isNotEmpty(this.context.getClassificationTypes())) {
            String classificationTypesQryStr = this.context.getClassificationTypesQryStr();
            if (indexQuery.length() != 0) {
                indexQuery.append(" AND ");
            }
            indexQuery.append("(").append(SearchProcessor.INDEX_SEARCH_PREFIX).append("\"").append(Constants.CLASSIFICATION_NAMES_KEY).append("\"").append(":" + classificationTypesQryStr).append(" OR ").append(SearchProcessor.INDEX_SEARCH_PREFIX).append("\"").append(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY).append("\"").append(":" + classificationTypesQryStr).append(")");
        }
    }

    void addClassificationFilterForBuiltInTypes(StringBuilder indexQuery) {
        if (indexQuery != null && CollectionUtils.isNotEmpty(this.context.getClassificationTypes()) && this.context.getClassificationTypes().iterator().next() == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
            if (indexQuery.length() != 0) {
                indexQuery.append(" AND ");
            }
            indexQuery.append("( *:* ").append("-").append(SearchProcessor.INDEX_SEARCH_PREFIX).append("\"").append(Constants.CLASSIFICATION_NAMES_KEY).append("\"").append(":[* TO *]").append(" AND ").append("-").append(SearchProcessor.INDEX_SEARCH_PREFIX).append("\"").append(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY).append("\"").append(":[* TO *]").append(")");
        }
    }

    void addActiveStateQueryFilter(StringBuilder indexQuery) {
        if (this.context.getSearchParameters().getExcludeDeletedEntities() && indexQuery != null) {
            if (indexQuery.length() != 0) {
                indexQuery.append(" AND ");
            }
            indexQuery.append("(").append(SearchProcessor.INDEX_SEARCH_PREFIX).append("\"").append(Constants.STATE_PROPERTY_KEY).append("\"").append(":ACTIVE").append(")");
        }
    }

    void addTypeAndSubTypesQueryFilter(StringBuilder indexQuery, String typeAndAllSubTypesQryStr) {
        if (indexQuery != null && StringUtils.isNotEmpty((CharSequence)typeAndAllSubTypesQryStr)) {
            if (indexQuery.length() > 0) {
                indexQuery.append(" AND ");
            }
            indexQuery.append("(").append(SearchProcessor.INDEX_SEARCH_PREFIX + "\"").append("__typeName").append("\":").append(typeAndAllSubTypesQryStr).append(")");
        }
    }
}

