/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;

public class EntityAttribute {
    private final String attributeKey;
    private final AtlasEntityType entityType;
    private final String attributeName;

    public EntityAttribute(String attributeKey, TransformerContext context) {
        int idx;
        this.attributeKey = attributeKey;
        int n = idx = attributeKey != null ? attributeKey.indexOf(46) : -1;
        if (idx != -1) {
            AtlasTypeRegistry typeRegistry;
            this.attributeName = StringUtils.trim((String)attributeKey.substring(idx + 1));
            AtlasTypeRegistry atlasTypeRegistry = typeRegistry = context != null ? context.getTypeRegistry() : null;
            if (typeRegistry != null) {
                String typeName = StringUtils.trim((String)attributeKey.substring(0, idx));
                this.entityType = typeRegistry.getEntityTypeByName(typeName);
            } else {
                this.entityType = null;
            }
        } else {
            this.entityType = null;
            this.attributeName = attributeKey;
        }
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public AtlasEntityType getEntityType() {
        return this.entityType;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean appliesToEntityType(String typeName) {
        return this.entityType == null || StringUtils.isEmpty((String)typeName) || this.entityType.getTypeAndAllSubTypes().contains(typeName);
    }
}

