/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HiveColumnEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hive_db.name", "hive_table.name", "hive_column.name", "hive_db.clusterName");

    public HiveColumnEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHiveColumnEntity(entity) ? new HiveColumnEntity(entity) : null;
    }

    private boolean isHiveColumnEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hive_column");
    }

    public static class HiveColumnEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private String databaseName;
        private String tableName;
        private String columnName;
        private String clusterName;
        private boolean isCustomAttributeUpdated = false;

        public HiveColumnEntity(AtlasEntity entity) {
            super(entity);
            this.columnName = (String)entity.getAttribute("name");
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            if (qualifiedName != null) {
                int databaseSeparatorIdx = qualifiedName.indexOf(46);
                int tableSeparatorIdx = databaseSeparatorIdx != -1 ? qualifiedName.indexOf(46, databaseSeparatorIdx + 1) : -1;
                int clusterSeparatorIdx = qualifiedName.lastIndexOf(64);
                this.databaseName = databaseSeparatorIdx != -1 ? qualifiedName.substring(0, databaseSeparatorIdx).trim() : "";
                this.tableName = tableSeparatorIdx != -1 ? qualifiedName.substring(databaseSeparatorIdx + 1, tableSeparatorIdx).trim() : "";
                this.clusterName = clusterSeparatorIdx != -1 ? qualifiedName.substring(clusterSeparatorIdx + 1).trim() : "";
            } else {
                this.databaseName = "";
                this.tableName = "";
                this.clusterName = "";
            }
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    return this.databaseName;
                }
                case "hive_table.name": {
                    return this.tableName;
                }
                case "hive_column.name": {
                    return this.columnName;
                }
                case "hive_db.clusterName": {
                    return this.clusterName;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hive_db.name": {
                    this.databaseName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_table.name": {
                    this.tableName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_column.name": {
                    this.columnName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hive_db.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("name", (Object)this.columnName);
                this.entity.setAttribute("qualifiedName", (Object)this.toQualifiedName());
            }
        }

        private String toQualifiedName() {
            return String.format("%s.%s.%s@%s", this.databaseName, this.tableName, this.columnName, this.clusterName);
        }
    }
}

