/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.audit.AuditSearchParameters;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.repository.ogm.AtlasAuditEntryDTO;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtlasService
public class AtlasAuditService {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuditService.class);
    public static final String ENTITY_TYPE_AUDIT_ENTRY = "__AtlasAuditEntry";
    private final DataAccess dataAccess;
    private final AtlasDiscoveryService discoveryService;

    @Inject
    public AtlasAuditService(DataAccess dataAccess, AtlasDiscoveryService discoveryService) {
        this.dataAccess = dataAccess;
        this.discoveryService = discoveryService;
    }

    @GraphTransaction
    public void save(AtlasAuditEntry entry) throws AtlasBaseException {
        this.dataAccess.saveNoLoad(entry);
    }

    public void add(AtlasAuditEntry.AuditOperation operation, String params, String result, long resultCount) throws AtlasBaseException {
        Date startTime = new Date(RequestContext.get().getRequestTime());
        Date endTime = new Date();
        this.add(operation, startTime, endTime, params, result, resultCount);
    }

    public void add(AtlasAuditEntry.AuditOperation operation, Date startTime, Date endTime, String params, String result, long resultCount) throws AtlasBaseException {
        RequestContext.get();
        String userName = RequestContext.getCurrentUser();
        String clientId = RequestContext.get().getClientIPAddress();
        if (StringUtils.isEmpty((String)clientId)) {
            try {
                clientId = InetAddress.getLocalHost().getHostName() + ":" + InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.error("Exception occurred during InetAddress retrieval", (Throwable)e);
                clientId = "unknown";
            }
        }
        this.add(userName, operation, clientId, startTime, endTime, params, result, resultCount);
    }

    public void add(String userName, AtlasAuditEntry.AuditOperation operation, String clientId, Date startTime, Date endTime, String params, String result, long resultCount) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasAuditService.add()");
        }
        AtlasAuditEntry entry = new AtlasAuditEntry();
        entry.setUserName(userName);
        entry.setOperation(operation);
        entry.setClientId(clientId);
        entry.setStartTime(startTime);
        entry.setEndTime(endTime);
        entry.setParams(params);
        entry.setResult(result);
        entry.setResultCount(resultCount);
        this.save(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addAuditEntry: user: {}, clientId: {}, operation: {} ", new Object[]{entry.getUserName(), entry.getClientId(), entry.getOperation()});
            LOG.debug("<== AtlasAuditService.add({})");
        }
    }

    public AtlasAuditEntry get(AtlasAuditEntry entry) throws AtlasBaseException {
        if (entry.getGuid() == null) {
            throw new AtlasBaseException("Entity does not have GUID set. load cannot proceed.");
        }
        return this.dataAccess.load(entry);
    }

    public List<AtlasAuditEntry> get(AuditSearchParameters auditSearchParameters) throws AtlasBaseException {
        if (auditSearchParameters == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Audit Search Parameters not specified"});
        }
        SearchParameters searchParameters = this.getSearchParameters(auditSearchParameters);
        searchParameters.setAttributes(this.getAuditEntityAttributes());
        AtlasSearchResult result = this.discoveryService.searchWithParameters(searchParameters);
        return this.toAtlasAuditEntries(result);
    }

    public AtlasAuditEntry toAtlasAuditEntry(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        AtlasAuditEntry ret = null;
        if (entityWithExtInfo != null && entityWithExtInfo.getEntity() != null) {
            ret = AtlasAuditEntryDTO.from(entityWithExtInfo.getEntity().getGuid(), entityWithExtInfo.getEntity().getAttributes());
        }
        return ret;
    }

    private Set<String> getAuditEntityAttributes() {
        return AtlasAuditEntryDTO.getAttributes();
    }

    private List<AtlasAuditEntry> toAtlasAuditEntries(AtlasSearchResult result) {
        ArrayList<AtlasAuditEntry> ret = new ArrayList<AtlasAuditEntry>();
        if (CollectionUtils.isNotEmpty((Collection)result.getEntities())) {
            for (AtlasEntityHeader entityHeader : result.getEntities()) {
                AtlasAuditEntry entry = AtlasAuditEntryDTO.from(entityHeader.getGuid(), entityHeader.getAttributes());
                if (entry == null) continue;
                ret.add(entry);
            }
        }
        return ret;
    }

    private SearchParameters getSearchParameters(AuditSearchParameters auditSearchParameters) throws AtlasBaseException {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setTypeName(ENTITY_TYPE_AUDIT_ENTRY);
        SearchParameters.FilterCriteria validFilter = this.getNonEmptyFilter(auditSearchParameters.getAuditFilters());
        searchParameters.setEntityFilters(validFilter);
        searchParameters.setLimit(auditSearchParameters.getLimit());
        searchParameters.setOffset(auditSearchParameters.getOffset());
        String sortBy = auditSearchParameters.getSortBy();
        this.validateSortByParameter(sortBy);
        searchParameters.setSortBy(auditSearchParameters.getSortBy());
        searchParameters.setSortOrder(auditSearchParameters.getSortOrder());
        return searchParameters;
    }

    private void validateSortByParameter(String sortBy) throws AtlasBaseException {
        if (StringUtils.isNotEmpty((String)sortBy) && !AtlasAuditEntryDTO.getAttributes().contains(sortBy)) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{sortBy, "Atlas Audit Entry"});
        }
    }

    private SearchParameters.FilterCriteria getNonEmptyFilter(SearchParameters.FilterCriteria auditFilter) throws AtlasBaseException {
        SearchParameters.FilterCriteria outCriteria = new SearchParameters.FilterCriteria();
        outCriteria.setCriterion(new ArrayList());
        if (auditFilter != null) {
            outCriteria.setCondition(auditFilter.getCondition());
            List givenFilterCriterion = auditFilter.getCriterion();
            for (SearchParameters.FilterCriteria each : givenFilterCriterion) {
                if (StringUtils.isNotEmpty((String)each.getAttributeName()) && !AtlasAuditEntryDTO.getAttributes().contains(each.getAttributeName())) {
                    throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{each.getAttributeName(), "Atlas Audit Entry"});
                }
                this.addParameterIfValueNotEmpty(outCriteria, each.getAttributeName(), each.getOperator(), each.getAttributeValue());
            }
        }
        return outCriteria;
    }

    private void addParameterIfValueNotEmpty(SearchParameters.FilterCriteria criteria, String attributeName, SearchParameters.Operator operator, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            SearchParameters.FilterCriteria filterCriteria = new SearchParameters.FilterCriteria();
            filterCriteria.setAttributeName(attributeName);
            filterCriteria.setAttributeValue(value);
            filterCriteria.setOperator(operator);
            criteria.getCriterion().add(filterCriteria);
        }
    }
}

