/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.utils.FixedBufferList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityAuditListenerV2
implements EntityChangeListenerV2 {
    private static final Logger LOG = LoggerFactory.getLogger(EntityAuditListenerV2.class);
    private static final ThreadLocal<FixedBufferList<EntityAuditEventV2>> AUDIT_EVENTS_BUFFER = ThreadLocal.withInitial(() -> new FixedBufferList(EntityAuditEventV2.class, AtlasConfiguration.NOTIFICATION_FIXED_BUFFER_ITEMS_INCREMENT_COUNT.getInt()));
    private final EntityAuditRepository auditRepository;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasInstanceConverter instanceConverter;

    @Inject
    public EntityAuditListenerV2(EntityAuditRepository auditRepository, AtlasTypeRegistry typeRegistry, AtlasInstanceConverter instanceConverter) {
        this.auditRepository = auditRepository;
        this.typeRegistry = typeRegistry;
        this.instanceConverter = instanceConverter;
    }

    @Override
    public void onEntitiesAdded(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        FixedBufferList<EntityAuditEventV2> entitiesAdded = this.getAuditEventsList();
        for (AtlasEntity entity : entities) {
            this.createEvent((EntityAuditEventV2)entitiesAdded.next(), entity, isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_CREATE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_CREATE);
        }
        this.auditRepository.putEventsV2(entitiesAdded.toList());
        RequestContext.get().endMetricRecord(metric);
    }

    @Override
    public void onEntitiesUpdated(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        RequestContext reqContext = RequestContext.get();
        AtlasPerfMetrics.MetricRecorder metric = reqContext.startMetricRecord("entityAudit");
        FixedBufferList<EntityAuditEventV2> updatedEvents = this.getAuditEventsList();
        Collection<Object> updatedEntites = AtlasConfiguration.STORE_DIFFERENTIAL_AUDITS.getBoolean() ? reqContext.getDifferentialEntities() : entities;
        for (AtlasEntity atlasEntity : updatedEntites) {
            EntityAuditEventV2.EntityAuditActionV2 action = isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_UPDATE : (reqContext.checkIfEntityIsForCustomAttributeUpdate(atlasEntity.getGuid()) ? EntityAuditEventV2.EntityAuditActionV2.CUSTOM_ATTRIBUTE_UPDATE : (reqContext.checkIfEntityIsForBusinessAttributeUpdate(atlasEntity.getGuid()) ? EntityAuditEventV2.EntityAuditActionV2.BUSINESS_ATTRIBUTE_UPDATE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_UPDATE));
            this.createEvent((EntityAuditEventV2)updatedEvents.next(), atlasEntity, action);
        }
        this.auditRepository.putEventsV2(updatedEvents.toList());
        RequestContext.get().endMetricRecord(metric);
    }

    @Override
    public void onEntitiesDeleted(List<AtlasEntity> entities, boolean isImport) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        FixedBufferList<EntityAuditEventV2> deletedEntities = this.getAuditEventsList();
        for (AtlasEntity entity : entities) {
            this.createEvent((EntityAuditEventV2)deletedEntities.next(), entity, isImport ? EntityAuditEventV2.EntityAuditActionV2.ENTITY_IMPORT_DELETE : EntityAuditEventV2.EntityAuditActionV2.ENTITY_DELETE, "Deleted entity");
        }
        this.auditRepository.putEventsV2(deletedEntities.toList());
        RequestContext.get().endMetricRecord(metric);
    }

    @Override
    public void onEntitiesPurged(List<AtlasEntity> entities) throws AtlasBaseException {
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
        FixedBufferList<EntityAuditEventV2> eventsPurged = this.getAuditEventsList();
        for (AtlasEntity entity : entities) {
            this.createEvent((EntityAuditEventV2)eventsPurged.next(), entity, EntityAuditEventV2.EntityAuditActionV2.ENTITY_PURGE);
        }
        this.auditRepository.putEventsV2(eventsPurged.toList());
        RequestContext.get().endMetricRecord(metric);
    }

    @Override
    public void onClassificationsAdded(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            FixedBufferList<EntityAuditEventV2> classificationsAdded = this.getAuditEventsList();
            for (AtlasClassification classification : classifications) {
                if (entity.getGuid().equals(classification.getEntityGuid())) {
                    this.createEvent((EntityAuditEventV2)classificationsAdded.next(), entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_ADD, "Added classification: " + AtlasType.toJson((Object)classification));
                    continue;
                }
                this.createEvent((EntityAuditEventV2)classificationsAdded.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD, "Added propagated classification: " + AtlasType.toJson((Object)classification));
            }
            this.auditRepository.putEventsV2(classificationsAdded.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onClassificationsAdded(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (AtlasClassification classification : classifications) {
                for (AtlasEntity entity : entities) {
                    if (entity.getGuid().equals(classification.getEntityGuid())) {
                        this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_ADD, "Added classification: " + AtlasType.toJson((Object)classification));
                        continue;
                    }
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD, "Added propagated classification: " + AtlasType.toJson((Object)classification));
                }
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onClassificationsUpdated(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            String guid = entity.getGuid();
            for (AtlasClassification classification : classifications) {
                if (guid.equals(classification.getEntityGuid())) {
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_UPDATE, "Updated classification: " + AtlasType.toJson((Object)classification));
                    continue;
                }
                if (this.isPropagatedClassificationAdded(guid, classification)) {
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD, "Added propagated classification: " + AtlasType.toJson((Object)classification));
                    continue;
                }
                if (this.isPropagatedClassificationDeleted(guid, classification)) {
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE, "Deleted propagated classification: " + classification.getTypeName());
                    continue;
                }
                this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_UPDATE, "Updated propagated classification: " + AtlasType.toJson((Object)classification));
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onClassificationsDeleted(AtlasEntity entity, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onClassificationsDeleted");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (AtlasClassification classification : classifications) {
                if (StringUtils.equals((CharSequence)entity.getGuid(), (CharSequence)classification.getEntityGuid())) {
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_DELETE, "Deleted classification: " + classification.getTypeName());
                    continue;
                }
                this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE, "Deleted propagated classification: " + classification.getTypeName());
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onClassificationsDeleted(List<AtlasEntity> entities, List<AtlasClassification> classifications) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(classifications) && CollectionUtils.isNotEmpty(entities)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onClassificationsDeleted");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (AtlasClassification classification : classifications) {
                for (AtlasEntity entity : entities) {
                    if (StringUtils.equals((CharSequence)entity.getGuid(), (CharSequence)classification.getEntityGuid())) {
                        this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.CLASSIFICATION_DELETE, "Deleted classification: " + classification.getTypeName());
                        continue;
                    }
                    this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE, "Deleted propagated classification: " + classification.getTypeName());
                }
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onTermAdded(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) throws AtlasBaseException {
        if (term != null && CollectionUtils.isNotEmpty(entities)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onTermAdded");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (AtlasRelatedObjectId relatedObjectId : entities) {
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(relatedObjectId.getGuid());
                if (entity == null) continue;
                this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.TERM_ADD, "Added term: " + term.toAuditString());
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onTermDeleted(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entities) throws AtlasBaseException {
        if (term != null && CollectionUtils.isNotEmpty(entities)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onTermDeleted");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (AtlasRelatedObjectId relatedObjectId : entities) {
                AtlasEntity entity = this.instanceConverter.getAndCacheEntity(relatedObjectId.getGuid());
                if (entity == null) continue;
                this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.TERM_DELETE, "Deleted term: " + term.toAuditString());
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onLabelsAdded(AtlasEntity entity, Set<String> labels) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(labels)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onLabelsAdded");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            String addedLabels = StringUtils.join(labels, (String)" ");
            this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.LABEL_ADD, "Added labels: " + addedLabels);
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onLabelsDeleted(AtlasEntity entity, Set<String> labels) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(labels)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("onLabelsDeleted");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            String deletedLabels = StringUtils.join(labels, (String)" ");
            this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.LABEL_DELETE, "Deleted labels: " + deletedLabels);
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    @Override
    public void onRelationshipsAdded(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("New relationship(s) added to repository(" + relationships.size() + ")");
        }
    }

    @Override
    public void onRelationshipsUpdated(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Relationship(s) updated(" + relationships.size() + ")");
        }
    }

    @Override
    public void onRelationshipsDeleted(List<AtlasRelationship> relationships, boolean isImport) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Relationship(s) deleted from repository(" + relationships.size() + ")");
        }
    }

    @Override
    public void onRelationshipsPurged(List<AtlasRelationship> relationships) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Relationship(s) purged from repository(" + relationships.size() + ")");
        }
    }

    @Override
    public void onBusinessAttributesUpdated(AtlasEntity entity, Map<String, Map<String, Object>> updatedBusinessAttributes) throws AtlasBaseException {
        if (MapUtils.isNotEmpty(updatedBusinessAttributes)) {
            AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("entityAudit");
            FixedBufferList<EntityAuditEventV2> events = this.getAuditEventsList();
            for (Map.Entry<String, Map<String, Object>> entry : updatedBusinessAttributes.entrySet()) {
                String bmName = entry.getKey();
                Map<String, Object> attributes = entry.getValue();
                String details = AtlasJson.toJson((Object)new AtlasStruct(bmName, attributes));
                this.createEvent((EntityAuditEventV2)events.next(), entity, EntityAuditEventV2.EntityAuditActionV2.BUSINESS_ATTRIBUTE_UPDATE, "Updated business attributes: " + details);
            }
            this.auditRepository.putEventsV2(events.toList());
            RequestContext.get().endMetricRecord(metric);
        }
    }

    private EntityAuditEventV2 createEvent(EntityAuditEventV2 entityAuditEventV2, AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action, String details) {
        entityAuditEventV2.setEntityId(entity.getGuid());
        entityAuditEventV2.setTimestamp(System.currentTimeMillis());
        entityAuditEventV2.setUser(RequestContext.get().getUser());
        entityAuditEventV2.setAction(action);
        entityAuditEventV2.setDetails(details);
        entityAuditEventV2.setEntity(entity);
        return entityAuditEventV2;
    }

    private EntityAuditEventV2 createEvent(EntityAuditEventV2 event, AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action) {
        String detail = this.getAuditEventDetail(entity, action);
        return this.createEvent(event, entity, action, detail);
    }

    private String getAuditEventDetail(AtlasEntity entity, EntityAuditEventV2.EntityAuditActionV2 action) {
        Map<String, Object> prunedAttributes = this.pruneEntityAttributesForAudit(entity);
        String auditPrefix = this.getV2AuditPrefix(action);
        String auditString = auditPrefix + AtlasType.toJson((Object)entity);
        byte[] auditBytes = auditString.getBytes(StandardCharsets.UTF_8);
        long auditSize = auditBytes != null ? (long)auditBytes.length : 0L;
        long auditMaxSize = this.auditRepository.repositoryMaxSize();
        if (auditMaxSize >= 0L && auditSize > auditMaxSize) {
            LOG.warn("audit record too long: entityType={}, guid={}, size={}; maxSize={}. entity attribute values not stored in audit", new Object[]{entity.getTypeName(), entity.getGuid(), auditSize, auditMaxSize});
            Map attrValues = entity.getAttributes();
            Map relAttrValues = entity.getRelationshipAttributes();
            entity.setAttributes(null);
            entity.setRelationshipAttributes(null);
            auditString = auditPrefix + AtlasType.toJson((Object)entity);
            auditBytes = auditString.getBytes(StandardCharsets.UTF_8);
            long l = auditSize = auditBytes != null ? (long)auditBytes.length : 0L;
            if (auditMaxSize >= 0L && auditSize > auditMaxSize) {
                LOG.warn("audit record still too long: entityType={}, guid={}, size={}; maxSize={}. audit will have only summary details", new Object[]{entity.getTypeName(), entity.getGuid(), auditSize, auditMaxSize});
                AtlasEntity shallowEntity = new AtlasEntity();
                shallowEntity.setGuid(entity.getGuid());
                shallowEntity.setTypeName(entity.getTypeName());
                shallowEntity.setCreateTime(entity.getCreateTime());
                shallowEntity.setUpdateTime(entity.getUpdateTime());
                shallowEntity.setCreatedBy(entity.getCreatedBy());
                shallowEntity.setUpdatedBy(entity.getUpdatedBy());
                shallowEntity.setStatus(entity.getStatus());
                shallowEntity.setVersion(entity.getVersion());
                auditString = auditPrefix + AtlasType.toJson((Object)shallowEntity);
            }
            entity.setAttributes(attrValues);
            entity.setRelationshipAttributes(relAttrValues);
        }
        this.restoreEntityAttributes(entity, prunedAttributes);
        return auditString;
    }

    private boolean isPropagatedClassificationAdded(String guid, AtlasClassification classification) {
        Map addedPropagations = RequestContext.get().getAddedPropagations();
        return this.hasPropagatedEntry(addedPropagations, guid, classification);
    }

    private boolean isPropagatedClassificationDeleted(String guid, AtlasClassification classification) {
        Map removedPropagations = RequestContext.get().getRemovedPropagations();
        return this.hasPropagatedEntry(removedPropagations, guid, classification);
    }

    private boolean hasPropagatedEntry(Map<String, List<AtlasClassification>> propagationsMap, String guid, AtlasClassification classification) {
        boolean ret = false;
        if (MapUtils.isNotEmpty(propagationsMap) && propagationsMap.containsKey(guid) && CollectionUtils.isNotEmpty((Collection)propagationsMap.get(guid))) {
            List<AtlasClassification> classifications = propagationsMap.get(guid);
            String classificationName = classification.getTypeName();
            String entityGuid = classification.getEntityGuid();
            for (AtlasClassification c : classifications) {
                if (!StringUtils.equals((CharSequence)c.getTypeName(), (CharSequence)classificationName) || !StringUtils.equals((CharSequence)c.getEntityGuid(), (CharSequence)entityGuid)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Map<String, Object> pruneEntityAttributesForAudit(AtlasEntity entity) {
        HashMap ret = null;
        Map entityAttributes = entity.getAttributes();
        List<String> excludeAttributes = this.auditRepository.getAuditExcludeAttributes(entity.getTypeName());
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (CollectionUtils.isNotEmpty(excludeAttributes) && MapUtils.isNotEmpty((Map)entityAttributes) && entityType != null) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                String attrName = attribute.getName();
                Object attrValue = entityAttributes.get(attrName);
                if (!excludeAttributes.contains(attrName)) continue;
                if (ret == null) {
                    ret = new HashMap();
                }
                ret.put(attrName, attrValue);
                entityAttributes.remove(attrName);
            }
        }
        return ret;
    }

    private void restoreEntityAttributes(AtlasEntity entity, Map<String, Object> prunedAttributes) {
        if (MapUtils.isEmpty(prunedAttributes)) {
            return;
        }
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType != null && MapUtils.isNotEmpty((Map)entityType.getAllAttributes())) {
            for (AtlasStructType.AtlasAttribute attribute : entityType.getAllAttributes().values()) {
                String attrName = attribute.getName();
                if (!prunedAttributes.containsKey(attrName)) continue;
                entity.setAttribute(attrName, prunedAttributes.get(attrName));
            }
        }
    }

    private String getV1AuditPrefix(EntityAuditEvent.EntityAuditAction action) {
        String ret;
        switch (action) {
            case ENTITY_CREATE: {
                ret = "Created: ";
                break;
            }
            case ENTITY_UPDATE: {
                ret = "Updated: ";
                break;
            }
            case ENTITY_DELETE: {
                ret = "Deleted: ";
                break;
            }
            case TAG_ADD: {
                ret = "Added classification: ";
                break;
            }
            case TAG_DELETE: {
                ret = "Deleted classification: ";
                break;
            }
            case TAG_UPDATE: {
                ret = "Updated classification: ";
                break;
            }
            case ENTITY_IMPORT_CREATE: {
                ret = "Created by import: ";
                break;
            }
            case ENTITY_IMPORT_UPDATE: {
                ret = "Updated by import: ";
                break;
            }
            case ENTITY_IMPORT_DELETE: {
                ret = "Deleted by import: ";
                break;
            }
            case TERM_ADD: {
                ret = "Added term: ";
                break;
            }
            case TERM_DELETE: {
                ret = "Deleted term: ";
                break;
            }
            default: {
                ret = "Unknown: ";
            }
        }
        return ret;
    }

    private String getV2AuditPrefix(EntityAuditEventV2.EntityAuditActionV2 action) {
        String ret;
        switch (action) {
            case ENTITY_CREATE: {
                ret = "Created: ";
                break;
            }
            case ENTITY_UPDATE: {
                ret = "Updated: ";
                break;
            }
            case CUSTOM_ATTRIBUTE_UPDATE: {
                ret = "Updated custom attribute: ";
                break;
            }
            case BUSINESS_ATTRIBUTE_UPDATE: {
                ret = "Updated business attribute: ";
                break;
            }
            case ENTITY_DELETE: {
                ret = "Deleted: ";
                break;
            }
            case ENTITY_PURGE: {
                ret = "Purged: ";
                break;
            }
            case CLASSIFICATION_ADD: {
                ret = "Added classification: ";
                break;
            }
            case CLASSIFICATION_DELETE: {
                ret = "Deleted classification: ";
                break;
            }
            case CLASSIFICATION_UPDATE: {
                ret = "Updated classification: ";
                break;
            }
            case ENTITY_IMPORT_CREATE: {
                ret = "Created by import: ";
                break;
            }
            case ENTITY_IMPORT_UPDATE: {
                ret = "Updated by import: ";
                break;
            }
            case ENTITY_IMPORT_DELETE: {
                ret = "Deleted by import: ";
                break;
            }
            case TERM_ADD: {
                ret = "Added term: ";
                break;
            }
            case TERM_DELETE: {
                ret = "Deleted term: ";
                break;
            }
            default: {
                ret = "Unknown: ";
            }
        }
        return ret;
    }

    private FixedBufferList<EntityAuditEventV2> getAuditEventsList() {
        FixedBufferList<EntityAuditEventV2> ret = AUDIT_EVENTS_BUFFER.get();
        ret.reset();
        return ret;
    }
}

