/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.repository.converters.AtlasStructFormatConverter;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasClassificationFormatConverter
extends AtlasStructFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasClassificationFormatConverter.class);

    public AtlasClassificationFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        super(registry, typeRegistry, TypeCategory.CLASSIFICATION);
    }

    public AtlasClassification fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        AtlasClassification ret = null;
        if (v1Obj != null) {
            AtlasClassificationType classificationType = (AtlasClassificationType)type;
            if (v1Obj instanceof Map) {
                Map v1Map = (Map)v1Obj;
                Map v1Attribs = (Map)v1Map.get("attributes");
                ret = MapUtils.isNotEmpty((Map)v1Attribs) ? new AtlasClassification(type.getTypeName(), this.fromV1ToV2((AtlasStructType)classificationType, v1Attribs, ctx)) : new AtlasClassification(type.getTypeName());
            } else if (v1Obj instanceof Struct) {
                Struct struct = (Struct)v1Obj;
                ret = new AtlasClassification(type.getTypeName(), this.fromV1ToV2((AtlasStructType)classificationType, struct.getValues(), ctx));
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map or Struct", v1Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }
}

