/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.repository.converters.AtlasStructFormatConverter;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.instance.AtlasSystemAttributes;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityFormatConverter
extends AtlasStructFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityFormatConverter.class);

    public AtlasEntityFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        super(registry, typeRegistry, TypeCategory.ENTITY);
    }

    @Override
    public boolean isValidValueV1(Object v1Obj, AtlasType type) {
        boolean ret;
        boolean bl = ret = v1Obj == null || v1Obj instanceof Id || v1Obj instanceof Referenceable;
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasEntityFormatConverter.isValidValueV1(type={}, value={}): {}", new Object[]{v1Obj != null ? v1Obj.getClass().getCanonicalName() : null, v1Obj, ret});
        }
        return ret;
    }

    public AtlasEntity fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext context) throws AtlasBaseException {
        AtlasEntity entity = null;
        if (v1Obj != null) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            if (v1Obj instanceof Referenceable) {
                Referenceable entRef = (Referenceable)v1Obj;
                String guid = entRef.getId().getId();
                if (!context.entityExists(guid)) {
                    entity = new AtlasEntity(entRef.getTypeName(), super.fromV1ToV2((AtlasStructType)entityType, entRef.getValues(), context));
                    entity.setGuid(entRef.getId().getId());
                    entity.setStatus(this.convertState(entRef.getId().getState()));
                    if (entRef.getSystemAttributes() != null) {
                        entity.setCreatedBy(entRef.getSystemAttributes().getCreatedBy());
                        entity.setCreateTime(entRef.getSystemAttributes().getCreatedTime());
                        entity.setUpdatedBy(entRef.getSystemAttributes().getModifiedBy());
                        entity.setUpdateTime(entRef.getSystemAttributes().getModifiedTime());
                    }
                    entity.setVersion(Long.valueOf(entRef.getId().getVersion()));
                    if (CollectionUtils.isNotEmpty((Collection)entRef.getTraitNames())) {
                        ArrayList<AtlasClassification> classifications = new ArrayList<AtlasClassification>();
                        AtlasFormatConverter traitConverter = this.converterRegistry.getConverter(TypeCategory.CLASSIFICATION);
                        for (String traitName : entRef.getTraitNames()) {
                            Struct trait = (Struct)entRef.getTraits().get(traitName);
                            AtlasType classifiType = this.typeRegistry.getType(traitName);
                            AtlasClassification classification = (AtlasClassification)traitConverter.fromV1ToV2(trait, classifiType, context);
                            classifications.add(classification);
                        }
                        entity.setClassifications(classifications);
                    }
                }
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Referenceable", v1Obj.getClass().getCanonicalName()});
            }
        }
        return entity;
    }

    @Override
    public Object fromV2ToV1(Object v2Obj, AtlasType type, AtlasFormatConverter.ConverterContext context) throws AtlasBaseException {
        Object ret = null;
        if (v2Obj != null) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            if (v2Obj instanceof Map) {
                Map v2Map = (Map)v2Obj;
                String idStr = (String)v2Map.get("guid");
                String typeName = type.getTypeName();
                if (StringUtils.isEmpty((CharSequence)idStr)) {
                    throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[0]);
                }
                Map v2Attribs = (Map)v2Map.get("attributes");
                ret = MapUtils.isEmpty((Map)v2Attribs) ? new Id(idStr, 0, typeName) : new Referenceable(idStr, typeName, super.fromV2ToV1((AtlasStructType)entityType, v2Attribs, context));
            } else if (v2Obj instanceof AtlasEntity) {
                AtlasEntity entity = (AtlasEntity)v2Obj;
                AtlasEntity.Status status = entity.getStatus();
                if (status == null) {
                    status = AtlasEntity.Status.ACTIVE;
                }
                Map v2Attribs = entity.getAttributes();
                Referenceable referenceable = new Referenceable(entity.getGuid(), entity.getTypeName(), status.name(), this.fromV2ToV1((AtlasStructType)entityType, v2Attribs, context), new AtlasSystemAttributes(entity.getCreatedBy(), entity.getUpdatedBy(), entity.getCreateTime(), entity.getUpdateTime()));
                if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
                    for (AtlasClassification classification : entity.getClassifications()) {
                        String traitName = classification.getTypeName();
                        AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(traitName);
                        AtlasFormatConverter formatConverter = classificationType != null ? this.converterRegistry.getConverter(classificationType.getTypeCategory()) : null;
                        Struct trait = formatConverter != null ? (Struct)formatConverter.fromV2ToV1(classification, (AtlasType)classificationType, context) : null;
                        if (trait == null) continue;
                        referenceable.getTraitNames().add(trait.getTypeName());
                        referenceable.getTraits().put(trait.getTypeName(), trait);
                    }
                }
                ret = referenceable;
            } else if (v2Obj instanceof AtlasObjectId) {
                AtlasEntity entity = context.getById(((AtlasObjectId)v2Obj).getGuid());
                if (entity == null) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"Could not find entity ", v2Obj.toString()});
                }
                ret = this.fromV2ToV1(entity, this.typeRegistry.getType(((AtlasObjectId)v2Obj).getTypeName()), context);
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map or AtlasEntity or String", v2Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }

    private AtlasEntity.Status convertState(Id.EntityState state) {
        return state != null && state.equals((Object)Id.EntityState.DELETED) ? AtlasEntity.Status.DELETED : AtlasEntity.Status.ACTIVE;
    }
}

