/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.converters;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.repository.converters.AtlasAbstractFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverter;
import org.apache.atlas.repository.converters.AtlasFormatConverters;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMapFormatConverter
extends AtlasAbstractFormatConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapFormatConverter.class);

    public AtlasMapFormatConverter(AtlasFormatConverters registry, AtlasTypeRegistry typeRegistry) {
        super(registry, typeRegistry, TypeCategory.MAP);
    }

    @Override
    public boolean isValidValueV1(Object v1Obj, AtlasType type) {
        boolean ret = false;
        if (v1Obj == null) {
            return true;
        }
        if (type instanceof AtlasMapType && v1Obj instanceof Map) {
            AtlasMapType mapType = (AtlasMapType)type;
            AtlasType keyType = mapType.getKeyType();
            AtlasType valueType = mapType.getValueType();
            AtlasFormatConverter keyConverter = null;
            AtlasFormatConverter valueConverter = null;
            Map v1Map = (Map)v1Obj;
            try {
                keyConverter = this.converterRegistry.getConverter(keyType.getTypeCategory());
                valueConverter = this.converterRegistry.getConverter(valueType.getTypeCategory());
            }
            catch (AtlasBaseException excp) {
                LOG.warn("failed to get key/value converter. type={}", (Object)type.getTypeName(), (Object)excp);
                ret = false;
            }
            if (keyConverter != null && valueConverter != null) {
                ret = true;
                for (Object key : v1Map.keySet()) {
                    Object value = v1Map.get(key);
                    ret = keyConverter.isValidValueV1(key, keyType) && valueConverter.isValidValueV1(value, valueType);
                    if (ret) continue;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AtlasArrayFormatConverter.isValidValueV1(type={}, value={}): {}", new Object[]{v1Obj != null ? v1Obj.getClass().getCanonicalName() : null, v1Obj, ret});
        }
        return ret;
    }

    @Override
    public Map fromV1ToV2(Object v1Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        HashMap<Object, Object> ret = null;
        if (v1Obj != null) {
            if (v1Obj instanceof Map) {
                AtlasMapType mapType = (AtlasMapType)type;
                AtlasType keyType = mapType.getKeyType();
                AtlasType valueType = mapType.getValueType();
                AtlasFormatConverter keyConverter = this.converterRegistry.getConverter(keyType.getTypeCategory());
                AtlasFormatConverter valueConverter = this.converterRegistry.getConverter(valueType.getTypeCategory());
                Map v1Map = (Map)v1Obj;
                ret = new HashMap<Object, Object>();
                for (Object key : v1Map.keySet()) {
                    Object value = v1Map.get(key);
                    Object v2Key = keyConverter.fromV1ToV2(key, keyType, ctx);
                    Object v2Value = valueConverter.fromV1ToV2(value, valueType, ctx);
                    ret.put(v2Key, v2Value);
                }
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map", v1Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }

    @Override
    public Map fromV2ToV1(Object v2Obj, AtlasType type, AtlasFormatConverter.ConverterContext ctx) throws AtlasBaseException {
        HashMap<Object, Object> ret = null;
        if (v2Obj != null) {
            if (v2Obj instanceof Map) {
                AtlasMapType mapType = (AtlasMapType)type;
                AtlasType keyType = mapType.getKeyType();
                AtlasType valueType = mapType.getValueType();
                AtlasFormatConverter keyConverter = this.converterRegistry.getConverter(keyType.getTypeCategory());
                AtlasFormatConverter valueConverter = this.converterRegistry.getConverter(valueType.getTypeCategory());
                Map v2Map = (Map)v2Obj;
                ret = new HashMap<Object, Object>();
                for (Object key : v2Map.keySet()) {
                    Object value = v2Map.get(key);
                    Object v2Key = keyConverter.fromV2ToV1(key, keyType, ctx);
                    Object v2Value = valueConverter.fromV2ToV1(value, valueType, ctx);
                    ret.put(v2Key, v2Value);
                }
            } else {
                throw new AtlasBaseException(AtlasErrorCode.UNEXPECTED_TYPE, new String[]{"Map", v2Obj.getClass().getCanonicalName()});
            }
        }
        return ret;
    }
}

