/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.commons.lang.StringUtils;

public abstract class ImportTransformer {
    private static final String TRANSFORMER_PARAMETER_SEPARATOR = "\\:";
    private static final String TRANSFORMER_NAME_ADD = "add";
    private static final String TRANSFORMER_NAME_CLEAR_ATTR = "clearAttrValue";
    private static final String TRANSFORMER_NAME_LOWERCASE = "lowercase";
    private static final String TRANSFORMER_NAME_UPPERCASE = "uppercase";
    private static final String TRANSFORMER_NAME_REMOVE_CLASSIFICATION = "removeClassification";
    private static final String TRANSFORMER_NAME_ADD_CLASSIFICATION = "addClassification";
    private static final String TRANSFORMER_NAME_REPLACE = "replace";
    private static final String TRANSFORMER_SET_DELETED = "setDeleted";
    private final String transformType;

    public static ImportTransformer getTransformer(String transformerSpec) throws AtlasBaseException {
        ImportTransformer ret;
        String key;
        Object[] params = StringUtils.split((String)transformerSpec, (String)TRANSFORMER_PARAMETER_SEPARATOR);
        String string = key = params == null || params.length < 1 ? transformerSpec : params[0];
        if (StringUtils.isEmpty((String)key)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, new String[]{"Error creating ImportTransformer. Invalid transformer-specification: {}.", transformerSpec});
        }
        if (key.equals(TRANSFORMER_NAME_REPLACE)) {
            String toFindStr = params == null || params.length < 2 ? "" : params[1];
            String replaceStr = params == null || params.length < 3 ? "" : params[2];
            ret = new Replace(toFindStr, replaceStr);
        } else if (key.equals(TRANSFORMER_NAME_LOWERCASE)) {
            ret = new Lowercase();
        } else if (key.equals(TRANSFORMER_NAME_UPPERCASE)) {
            ret = new Uppercase();
        } else if (key.equals(TRANSFORMER_NAME_REMOVE_CLASSIFICATION)) {
            String name = params == null || params.length < 1 ? "" : StringUtils.join((Object[])params, (String)":", (int)1, (int)params.length);
            ret = new RemoveClassification(name);
        } else if (key.equals(TRANSFORMER_NAME_ADD)) {
            String name = params == null || params.length < 1 ? "" : StringUtils.join((Object[])params, (String)":", (int)1, (int)params.length);
            ret = new AddValueToAttribute(name);
        } else if (key.equals(TRANSFORMER_NAME_CLEAR_ATTR)) {
            String name = params == null || params.length < 1 ? "" : StringUtils.join((Object[])params, (String)":", (int)1, (int)params.length);
            ret = new ClearAttributes(name);
        } else if (key.equals(TRANSFORMER_SET_DELETED)) {
            ret = new SetDeleted();
        } else if (key.equals(TRANSFORMER_NAME_ADD_CLASSIFICATION)) {
            String name = params == null || params.length < 1 ? "" : params[1];
            ret = new AddClassification(name, (String)(params != null && params.length == 3 ? params[2] : ""));
        } else {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_VALUE, new String[]{"Error creating ImportTransformer. Unknown transformer: {}.", transformerSpec});
        }
        return ret;
    }

    public String getTransformType() {
        return this.transformType;
    }

    public abstract Object apply(Object var1) throws AtlasBaseException;

    protected ImportTransformer(String transformType) {
        this.transformType = transformType;
    }

    static class SetDeleted
    extends ImportTransformer {
        protected SetDeleted() {
            super(ImportTransformer.TRANSFORMER_SET_DELETED);
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return o;
            }
            if (!(o instanceof AtlasEntity)) {
                return o;
            }
            AtlasEntity entity = (AtlasEntity)o;
            entity.setStatus(AtlasEntity.Status.DELETED);
            return entity;
        }
    }

    static class ClearAttributes
    extends ImportTransformer {
        private String[] attrNames;

        protected ClearAttributes(String attrNames) {
            super(ImportTransformer.TRANSFORMER_NAME_CLEAR_ATTR);
            this.attrNames = StringUtils.split((String)attrNames, (String)",");
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return o;
            }
            if (!(o instanceof AtlasEntity)) {
                return o;
            }
            AtlasEntity entity = (AtlasEntity)o;
            for (String attrName : this.attrNames) {
                entity.setAttribute(attrName, null);
            }
            return entity;
        }
    }

    static class AddValueToAttribute
    extends ImportTransformer {
        private final String nameValuePair;
        private String attrName;
        private String attrValueRaw;
        private Object attrValue;

        protected AddValueToAttribute(String nameValuePair) {
            super(ImportTransformer.TRANSFORMER_NAME_ADD);
            this.nameValuePair = nameValuePair;
            this.setAttrNameValue(this.nameValuePair);
        }

        private void setAttrNameValue(String nameValuePair) {
            String SEPARATOR_EQUALS = "=";
            if (!nameValuePair.contains(SEPARATOR_EQUALS)) {
                return;
            }
            String[] splits = StringUtils.split((String)nameValuePair, (String)SEPARATOR_EQUALS);
            if (splits.length == 0) {
                return;
            }
            if (splits.length >= 1) {
                this.attrName = splits[0];
            }
            if (splits.length >= 1) {
                this.attrValueRaw = splits[1];
            }
            this.setAttrValue(this.attrValueRaw);
        }

        private void setAttrValue(String attrValueRaw) {
            String type_prefix = "list:";
            if (attrValueRaw.startsWith("list:")) {
                final String item = StringUtils.remove((String)attrValueRaw, (String)"list:");
                this.attrValue = new ArrayList<String>(){
                    {
                        this.add(item);
                    }
                };
            } else {
                this.attrValue = attrValueRaw;
            }
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return o;
            }
            if (!(o instanceof AtlasEntity)) {
                return o;
            }
            AtlasEntity entity = (AtlasEntity)o;
            Object attrExistingValue = entity.getAttribute(this.attrName);
            if (attrExistingValue == null) {
                entity.setAttribute(this.attrName, this.attrValue);
            } else if (attrExistingValue instanceof List) {
                List list = (List)attrExistingValue;
                if (this.attrValue instanceof List) {
                    list.addAll((List)this.attrValue);
                } else {
                    list.add(this.attrValue);
                }
            } else {
                entity.setAttribute(this.attrName, (Object)this.attrValueRaw);
            }
            return entity;
        }
    }

    static class RemoveClassification
    extends ImportTransformer {
        private final String classificationToBeRemoved;

        public RemoveClassification(String name) {
            super(ImportTransformer.TRANSFORMER_NAME_REMOVE_CLASSIFICATION);
            this.classificationToBeRemoved = name;
        }

        @Override
        public Object apply(Object o) {
            if (!(o instanceof AtlasEntity)) {
                return o;
            }
            AtlasEntity entity = (AtlasEntity)o;
            if (entity.getClassifications().size() == 0) {
                return o;
            }
            ArrayList<AtlasClassification> toRemove = null;
            for (AtlasClassification classification : entity.getClassifications()) {
                if (!classification.getTypeName().equals(this.classificationToBeRemoved)) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<AtlasClassification>();
                }
                toRemove.add(classification);
            }
            if (toRemove != null) {
                entity.getClassifications().removeAll(toRemove);
            }
            return entity;
        }

        public String toString() {
            return String.format("%s=%s", "RemoveClassification", this.classificationToBeRemoved);
        }
    }

    static class AddClassification
    extends ImportTransformer {
        private static final String FILTER_SCOPE_TOP_LEVEL = "topLevel";
        private final String scope;
        private final String classificationName;
        private List<AtlasObjectId> filters;

        public AddClassification(String name, String scope) {
            super(ImportTransformer.TRANSFORMER_NAME_REMOVE_CLASSIFICATION);
            this.classificationName = name;
            this.scope = scope;
            this.filters = new ArrayList<AtlasObjectId>();
        }

        public void addFilter(AtlasObjectId objectId) {
            this.filters.add(objectId);
        }

        @Override
        public Object apply(Object o) {
            if (!(o instanceof AtlasEntity)) {
                return o;
            }
            AtlasEntity entity = (AtlasEntity)o;
            if (!this.passThruFilters(entity)) {
                return o;
            }
            if (entity.getClassifications() == null) {
                entity.setClassifications(new ArrayList());
            }
            for (AtlasClassification c : entity.getClassifications()) {
                if (!c.getTypeName().equals(this.classificationName)) continue;
                return entity;
            }
            entity.getClassifications().add(new AtlasClassification(this.classificationName));
            return entity;
        }

        private boolean passThruFilters(AtlasEntity entity) {
            if (StringUtils.isEmpty((String)this.scope) || !this.scope.equals(FILTER_SCOPE_TOP_LEVEL)) {
                return true;
            }
            for (AtlasObjectId filter : this.filters) {
                if (!this.isMatch(filter, entity)) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(AtlasObjectId objectId, AtlasEntity entity) {
            boolean ret = true;
            if (StringUtils.isEmpty((String)objectId.getGuid())) {
                ret = Objects.equals(objectId.getTypeName(), entity.getTypeName());
                if (ret) {
                    for (Map.Entry entry : objectId.getUniqueAttributes().entrySet()) {
                        if (ret = ret && Objects.equals(entity.getAttribute((String)entry.getKey()), entry.getValue())) continue;
                        break;
                    }
                }
                return ret;
            }
            return Objects.equals(objectId.getGuid(), entity.getGuid());
        }

        public String toString() {
            return String.format("%s=%s", "AddClassification", this.classificationName);
        }

        public String getClassificationName() {
            return this.classificationName;
        }
    }

    static class Uppercase
    extends ImportTransformer {
        public Uppercase() {
            super(ImportTransformer.TRANSFORMER_NAME_UPPERCASE);
        }

        @Override
        public Object apply(Object o) {
            Object ret = o;
            if (o instanceof String) {
                ret = StringUtils.upperCase((String)((String)o));
            }
            return ret;
        }
    }

    static class Lowercase
    extends ImportTransformer {
        public Lowercase() {
            super(ImportTransformer.TRANSFORMER_NAME_LOWERCASE);
        }

        @Override
        public Object apply(Object o) {
            Object ret = o;
            if (o instanceof String) {
                ret = StringUtils.lowerCase((String)((String)o));
            }
            return ret;
        }
    }

    static class Replace
    extends ImportTransformer {
        private final String toFindStr;
        private final String replaceStr;

        public Replace(String toFindStr, String replaceStr) {
            super(ImportTransformer.TRANSFORMER_NAME_REPLACE);
            this.toFindStr = toFindStr;
            this.replaceStr = replaceStr;
        }

        public String getToFindStr() {
            return this.toFindStr;
        }

        public String getReplaceStr() {
            return this.replaceStr;
        }

        @Override
        public Object apply(Object o) {
            Object ret = o;
            if (o instanceof String) {
                ret = StringUtils.replace((String)((String)o), (String)this.toFindStr, (String)this.replaceStr);
            }
            return ret;
        }
    }
}

