/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.TypeAttributeDifference;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;

public class ImportTypeDefProcessor {
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasTypeRegistry typeRegistry;
    private TypeAttributeDifference typeAttributeDifference;

    public ImportTypeDefProcessor(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
        this.typeAttributeDifference = new TypeAttributeDifference(typeDefStore, typeRegistry);
    }

    public void processTypes(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        this.setGuidToEmpty(typeDefinitionMap);
        AtlasTypesDef typesToCreate = AtlasTypeDefStoreInitializer.getTypesToCreate(typeDefinitionMap, this.typeRegistry);
        if (!typesToCreate.isEmpty()) {
            this.typeDefStore.createTypesDef(typesToCreate);
            this.updateMetricsForTypesDef(typesToCreate, result);
        }
        this.typeAttributeDifference.updateTypes(typeDefinitionMap, result);
    }

    private void setGuidToEmpty(AtlasTypesDef typesDef) {
        for (AtlasEntityDef def : typesDef.getEntityDefs()) {
            def.setGuid(null);
        }
        for (AtlasEntityDef def : typesDef.getClassificationDefs()) {
            def.setGuid(null);
        }
        for (AtlasEntityDef def : typesDef.getEnumDefs()) {
            def.setGuid(null);
        }
        for (AtlasEntityDef def : typesDef.getStructDefs()) {
            def.setGuid(null);
        }
        for (AtlasEntityDef def : typesDef.getRelationshipDefs()) {
            def.setGuid(null);
        }
        for (AtlasEntityDef def : typesDef.getBusinessMetadataDefs()) {
            def.setGuid(null);
        }
    }

    private void updateMetricsForTypesDef(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) {
        result.incrementMeticsCounter("typedef:classification", typeDefinitionMap.getClassificationDefs().size());
        result.incrementMeticsCounter("typedef:enum", typeDefinitionMap.getEnumDefs().size());
        result.incrementMeticsCounter("typedef:entitydef", typeDefinitionMap.getEntityDefs().size());
        result.incrementMeticsCounter("typedef:struct", typeDefinitionMap.getStructDefs().size());
        result.incrementMeticsCounter("typedef:relationship", typeDefinitionMap.getRelationshipDefs().size());
        result.incrementMeticsCounter("typedef:businessmetadata", typeDefinitionMap.getBusinessMetadataDefs().size());
    }
}

