/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEntityFetchByExportRequest {
    private static final Logger LOG = LoggerFactory.getLogger(StartEntityFetchByExportRequest.class);
    static final String DEFAULT_MATCH = "*";
    static final String BINDING_PARAMETER_TYPENAME = "typeName";
    static final String BINDING_PARAMETER_ATTR_NAME = "attrName";
    static final String BINDING_PARAMTER_ATTR_VALUE = "attrValue";
    private AtlasGraph atlasGraph;
    private AtlasTypeRegistry typeRegistry;
    private Map<String, String> matchTypeQuery;

    public StartEntityFetchByExportRequest(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry, AtlasGremlinQueryProvider gremlinQueryProvider) {
        this.typeRegistry = typeRegistry;
        this.atlasGraph = atlasGraph;
        this.initMatchTypeQueryMap(gremlinQueryProvider);
    }

    private void initMatchTypeQueryMap(final AtlasGremlinQueryProvider gremlinQueryProvider) {
        this.matchTypeQuery = new HashMap<String, String>(){
            {
                this.put("startsWith", gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_STARTS_WITH));
                this.put("endsWith", gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_ENDS_WITH));
                this.put("contains", gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_CONTAINS));
                this.put("matches", gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_MATCHES));
                this.put("forType", gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_ALL_FOR_TYPE));
                this.put(StartEntityFetchByExportRequest.DEFAULT_MATCH, gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_TYPE_DEFAULT));
            }
        };
    }

    public List<AtlasObjectId> get(AtlasExportRequest exportRequest) {
        ArrayList<AtlasObjectId> list = new ArrayList<AtlasObjectId>();
        for (AtlasObjectId objectId : exportRequest.getItemsToExport()) {
            List<String> guids = this.get(exportRequest, objectId);
            if (guids.isEmpty()) continue;
            objectId.setGuid(guids.get(0));
            list.add(objectId);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> get(AtlasExportRequest exportRequest, AtlasObjectId item) {
        List<Object> ret;
        block8: {
            List<Object> list;
            String matchType;
            block7: {
                block6: {
                    ret = new ArrayList<String>();
                    matchType = exportRequest.getMatchTypeOptionValue();
                    if (!StringUtils.isNotEmpty((CharSequence)item.getGuid())) break block6;
                    ret.add(item.getGuid());
                    ArrayList<String> arrayList = ret;
                    LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
                    return arrayList;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)matchType, (CharSequence)"forType") || !StringUtils.isNotEmpty((CharSequence)item.getTypeName())) break block7;
                ret = this.getEntitiesForMatchTypeType(item, matchType);
                List<String> list2 = ret;
                LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
                return list2;
            }
            try {
                if (!StringUtils.isNotEmpty((CharSequence)item.getTypeName()) || !MapUtils.isNotEmpty((Map)item.getUniqueAttributes())) break block8;
                list = ret = this.getEntitiesForMatchTypeUsingUniqueAttributes(item, matchType);
            }
            catch (AtlasBaseException ex) {
                try {
                    LOG.error("Error fetching starting entity for: {}", (Object)item, (Object)ex);
                }
                catch (Throwable throwable) {
                    LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
                    throw throwable;
                }
                LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
            }
            LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
            return list;
        }
        LOG.info("export(item={}; matchType={}, fetchType={}): found {} entities: options: {}", new Object[]{item, exportRequest.getMatchTypeOptionValue(), exportRequest.getFetchTypeOptionValue(), ret.size(), AtlasType.toJson((Object)exportRequest)});
        return ret;
    }

    private List<String> getEntitiesForMatchTypeUsingUniqueAttributes(AtlasObjectId item, String matchType) throws AtlasBaseException {
        String queryTemplate = this.getQueryTemplateForMatchType(matchType);
        String typeName = item.getTypeName();
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        HashSet<String> ret = new HashSet<String>();
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
        }
        for (Map.Entry e : item.getUniqueAttributes().entrySet()) {
            List<String> guids;
            String attrName = (String)e.getKey();
            Object attrValue = e.getValue();
            AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(attrName);
            if (attribute == null || attrValue == null || !CollectionUtils.isNotEmpty(guids = this.executeGremlinQuery(queryTemplate, this.getBindingsForObjectId(typeName, attribute.getQualifiedName(), e.getValue())))) continue;
            ret.addAll(guids);
        }
        return new ArrayList<String>(ret);
    }

    private List<String> getEntitiesForMatchTypeType(AtlasObjectId item, String matchType) {
        return this.executeGremlinQuery(this.getQueryTemplateForMatchType(matchType), this.getBindingsForTypeName(item.getTypeName()));
    }

    @VisibleForTesting
    String getQueryTemplateForMatchType(String matchType) {
        return this.matchTypeQuery.containsKey(matchType) ? this.matchTypeQuery.get(matchType) : this.matchTypeQuery.get(DEFAULT_MATCH);
    }

    private HashMap<String, Object> getBindingsForTypeName(final String typeName) {
        return new HashMap<String, Object>(){
            {
                this.put(StartEntityFetchByExportRequest.BINDING_PARAMETER_TYPENAME, new HashSet<String>(Arrays.asList(StringUtils.split((String)typeName, (String)","))));
            }
        };
    }

    private HashMap<String, Object> getBindingsForObjectId(final String typeName, final String attrName, final Object attrValue) {
        return new HashMap<String, Object>(){
            {
                this.put(StartEntityFetchByExportRequest.BINDING_PARAMETER_TYPENAME, typeName);
                this.put(StartEntityFetchByExportRequest.BINDING_PARAMETER_ATTR_NAME, attrName);
                this.put(StartEntityFetchByExportRequest.BINDING_PARAMTER_ATTR_VALUE, attrValue);
            }
        };
    }

    @VisibleForTesting
    List<String> executeGremlinQuery(String query, Map<String, Object> bindings) {
        try {
            return (List)this.atlasGraph.executeGremlinScript(this.getScriptEngine(), bindings, query, false);
        }
        catch (ScriptException e) {
            LOG.error("Script execution failed for query: ", (Object)query, (Object)e);
            return null;
        }
    }

    public ScriptEngine getScriptEngine() {
        try {
            return this.atlasGraph.getGremlinScriptEngine();
        }
        catch (AtlasBaseException e) {
            LOG.error("Error initializing script engine.", (Throwable)e);
            return null;
        }
    }
}

