/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ExtractStrategy;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexExtractor
implements ExtractStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(VertexExtractor.class);
    private static final String PROPERTY_IS_PROCESS = "isProcess";
    private static final String QUERY_BINDING_START_GUID = "startGuid";
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private final Map<String, Object> bindings;
    private AtlasGraph atlasGraph;
    private AtlasTypeRegistry typeRegistry;
    private ScriptEngine scriptEngine;

    public VertexExtractor(AtlasGraph atlasGraph, AtlasTypeRegistry typeRegistry) {
        this.atlasGraph = atlasGraph;
        this.typeRegistry = typeRegistry;
        try {
            this.scriptEngine = atlasGraph.getGremlinScriptEngine();
        }
        catch (AtlasBaseException e) {
            LOG.error("Script Engine: Instantiation failed!");
        }
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.bindings = new HashMap<String, Object>();
    }

    @Override
    public void fullFetch(AtlasEntity entity, ExportService.ExportContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> fullFetch({}): guidsToProcess {}", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), (Object)context.guidsToProcess.size());
        }
        String query = this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_FULL);
        this.bindings.clear();
        this.bindings.put(QUERY_BINDING_START_GUID, entity.getGuid());
        List<Map<String, Object>> result = this.executeGremlinQuery(query, context);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (Map<String, Object> hashMap : result) {
            String guid = (String)hashMap.get("__guid");
            boolean isLineage = (Boolean)hashMap.get(PROPERTY_IS_PROCESS);
            if (context.getSkipLineage() && isLineage || context.guidsProcessed.contains(guid)) continue;
            context.addToBeProcessed(isLineage, guid, ExportService.TraversalDirection.BOTH);
        }
    }

    @Override
    public void connectedFetch(AtlasEntity entity, ExportService.ExportContext context) {
        ExportService.TraversalDirection direction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> connectedFetch({}): guidsToProcess {}", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), (Object)context.guidsToProcess.size());
        }
        if ((direction = context.guidDirection.get(entity.getGuid())) == null || direction == ExportService.TraversalDirection.UNKNOWN) {
            this.getConnectedEntityGuids(entity, context, ExportService.TraversalDirection.OUTWARD, ExportService.TraversalDirection.INWARD);
        } else {
            if (this.isProcessEntity(entity)) {
                direction = ExportService.TraversalDirection.OUTWARD;
            }
            this.getConnectedEntityGuids(entity, context, direction);
        }
    }

    @Override
    public void close() {
        if (this.scriptEngine != null) {
            this.atlasGraph.releaseGremlinScriptEngine(this.scriptEngine);
        }
    }

    private void getConnectedEntityGuids(AtlasEntity entity, ExportService.ExportContext context, ExportService.TraversalDirection ... directions) {
        if (directions == null) {
            return;
        }
        for (ExportService.TraversalDirection direction : directions) {
            String query = this.getQueryForTraversalDirection(direction);
            this.bindings.clear();
            this.bindings.put(QUERY_BINDING_START_GUID, entity.getGuid());
            List<Map<String, Object>> result = this.executeGremlinQuery(query, context);
            if (CollectionUtils.isEmpty(result)) continue;
            for (Map<String, Object> hashMap : result) {
                String guid = (String)hashMap.get("__guid");
                ExportService.TraversalDirection currentDirection = context.guidDirection.get(guid);
                boolean isLineage = (Boolean)hashMap.get(PROPERTY_IS_PROCESS);
                if (context.skipLineage && isLineage) continue;
                if (currentDirection == null) {
                    context.addToBeProcessed(isLineage, guid, direction);
                    continue;
                }
                if (currentDirection != ExportService.TraversalDirection.OUTWARD || direction != ExportService.TraversalDirection.INWARD) continue;
                context.guidsProcessed.remove(guid);
                context.addToBeProcessed(isLineage, guid, direction);
            }
        }
    }

    private boolean isProcessEntity(AtlasEntity entity) {
        String typeName = entity.getTypeName();
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
        return entityType.isSubTypeOf("Process");
    }

    private String getQueryForTraversalDirection(ExportService.TraversalDirection direction) {
        switch (direction) {
            case INWARD: {
                return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_CONNECTED_IN_EDGE);
            }
        }
        return this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.EXPORT_BY_GUID_CONNECTED_OUT_EDGE);
    }

    private List<Map<String, Object>> executeGremlinQuery(String query, ExportService.ExportContext context) {
        try {
            return (List)this.atlasGraph.executeGremlinScript(this.scriptEngine, this.bindings, query, false);
        }
        catch (ScriptException e) {
            LOG.error("Script execution failed for query: ", (Object)query, (Object)e);
            return null;
        }
    }
}

