/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.migration.MigrationImportStatus;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.migration.DataMigrationStatusService;
import org.apache.atlas.repository.migration.FileWatcher;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileMigrationImporter
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ZipFileMigrationImporter.class);
    private static final String APPLICATION_PROPERTY_MIGRATION_NUMER_OF_WORKERS = "atlas.migration.mode.workers";
    private static final String APPLICATION_PROPERTY_MIGRATION_BATCH_SIZE = "atlas.migration.mode.batch.size";
    private static final String DEFAULT_NUMBER_OF_WORKERS = "4";
    private static final String DEFAULT_BATCH_SIZE = "100";
    private static final String ZIP_FILE_COMMENT_ENTITIES_COUNT = "entitiesCount";
    private static final String ZIP_FILE_COMMENT_TOTAL_COUNT = "total";
    private static final String ENV_USER_NAME = "user.name";
    private final ImportService importService;
    private final String fileToImport;
    private DataMigrationStatusService dataMigrationStatusService;
    private MigrationImportStatus migrationImportStatus;

    public ZipFileMigrationImporter(ImportService importService, String fileName) {
        this.importService = importService;
        this.fileToImport = fileName;
        this.dataMigrationStatusService = new DataMigrationStatusService(AtlasGraphProvider.getGraphInstance());
    }

    @Override
    public void run() {
        try {
            this.detectFileToImport();
            int streamSize = this.getStreamSizeFromComment(this.fileToImport);
            this.migrationImportStatus = this.getCreateMigrationStatus(this.fileToImport, streamSize);
            this.performImport(this.fileToImport, streamSize, Long.toString(this.migrationImportStatus.getCurrentIndex()));
            this.dataMigrationStatusService.setStatus("DONE");
        }
        catch (IOException e) {
            LOG.error("Migration Import: IO Error!", (Throwable)e);
            this.dataMigrationStatusService.setStatus("FAIL");
        }
        catch (AtlasBaseException e) {
            LOG.error("Migration Import: Error!", (Throwable)e);
            this.dataMigrationStatusService.setStatus("FAIL");
        }
    }

    private MigrationImportStatus getCreateMigrationStatus(String fileName, int streamSize) {
        MigrationImportStatus status = new MigrationImportStatus(fileName);
        status.setTotalCount((long)streamSize);
        MigrationImportStatus statusRetrieved = this.dataMigrationStatusService.getCreate(status);
        LOG.info("DataMigrationStatusService: Position: {}", (Object)statusRetrieved.getCurrentIndex());
        this.dataMigrationStatusService.setStatus("STARTED");
        return statusRetrieved;
    }

    private void detectFileToImport() throws IOException {
        FileWatcher fileWatcher = new FileWatcher(this.fileToImport);
        fileWatcher.start();
    }

    private int getStreamSizeFromComment(String fileToImport) {
        int ret = 1;
        try {
            ZipFile zipFile = new ZipFile(fileToImport);
            String comment = zipFile.getComment();
            ret = this.processZipFileStreamSizeComment(comment);
            zipFile.close();
        }
        catch (IOException e) {
            LOG.error("Error opening ZIP file: {}", (Object)fileToImport, (Object)e);
        }
        return ret;
    }

    private int processZipFileStreamSizeComment(String comment) {
        if (StringUtils.isEmpty((String)comment)) {
            return 1;
        }
        Map map = (Map)AtlasType.fromJson((String)comment, Map.class);
        int entitiesCount = (Integer)map.get(ZIP_FILE_COMMENT_ENTITIES_COUNT);
        int totalCount = (Integer)map.get(ZIP_FILE_COMMENT_TOTAL_COUNT);
        LOG.info("ZipFileMigrationImporter: Zip file: Comment: streamSize: {}: total: {}", (Object)entitiesCount, (Object)totalCount);
        return entitiesCount;
    }

    private void performImport(String fileToImport, int streamSize, String startPosition) throws AtlasBaseException {
        try {
            LOG.info("Migration Import: {}: Starting at: {}...", (Object)fileToImport, (Object)startPosition);
            FileInputStream fs = new FileInputStream(new File(fileToImport));
            RequestContext.get().setUser(this.getUserNameFromEnvironment(), null);
            this.importService.run(fs, this.getImportRequest(fileToImport, streamSize, startPosition), this.getUserNameFromEnvironment(), InetAddress.getLocalHost().getHostName(), InetAddress.getLocalHost().getHostAddress());
        }
        catch (Exception ex) {
            LOG.error("Migration Import: Error loading zip for migration!", (Throwable)ex);
            throw new AtlasBaseException((Throwable)ex);
        }
        finally {
            LOG.info("Migration Import: {}: Done!", (Object)fileToImport);
        }
    }

    private String getUserNameFromEnvironment() {
        return System.getProperty(ENV_USER_NAME);
    }

    private AtlasImportRequest getImportRequest(String fileToImport, int streamSize, String position) throws AtlasException {
        AtlasImportRequest request = new AtlasImportRequest();
        request.setOption("migrationFileName", fileToImport);
        request.setSizeOption(streamSize);
        request.setOption("migration", "true");
        request.setOption("numWorkers", this.getPropertyValue(APPLICATION_PROPERTY_MIGRATION_NUMER_OF_WORKERS, DEFAULT_NUMBER_OF_WORKERS));
        request.setOption("batchSize", this.getPropertyValue(APPLICATION_PROPERTY_MIGRATION_BATCH_SIZE, DEFAULT_BATCH_SIZE));
        request.setOption("startPosition", StringUtils.isEmpty((String)position) ? "0" : position);
        return request;
    }

    private String getPropertyValue(String property, String defaultValue) throws AtlasException {
        return ApplicationProperties.get().getString(property, defaultValue);
    }
}

