/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.profile.AtlasUserProfile;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.repository.ogm.profiles.AtlasSavedSearchDTO;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Component
public class AtlasUserProfileDTO
extends AbstractDataTransferObject<AtlasUserProfile> {
    public static final String ENTITY_TYPE_NAME = "__AtlasUserProfile";
    public static final String PROPERTY_USER_NAME = "name";
    private static final String PROPERTY_FULL_NAME = "fullName";
    private static final String PROPERTY_SAVED_SEARCHES = "savedSearches";
    private final AtlasSavedSearchDTO savedSearchDTO;

    @Inject
    public AtlasUserProfileDTO(AtlasTypeRegistry typeRegistry, AtlasSavedSearchDTO savedSearchDTO) {
        super(typeRegistry, AtlasUserProfile.class, ENTITY_TYPE_NAME);
        this.savedSearchDTO = savedSearchDTO;
    }

    @Override
    public AtlasUserProfile from(AtlasEntity entity) {
        AtlasUserProfile profile = new AtlasUserProfile();
        profile.setGuid(entity.getGuid());
        profile.setName((String)entity.getAttribute(PROPERTY_USER_NAME));
        profile.setFullName((String)entity.getAttribute(PROPERTY_FULL_NAME));
        return profile;
    }

    @Override
    public AtlasUserProfile from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        AtlasUserProfile userProfile = this.from(entityWithExtInfo.getEntity());
        Object savedSearches = entityWithExtInfo.getEntity().getAttribute(PROPERTY_SAVED_SEARCHES);
        if (savedSearches instanceof Collection) {
            for (Object o : (Collection)savedSearches) {
                AtlasObjectId ssObjId;
                AtlasEntity ssEntity;
                if (!(o instanceof AtlasObjectId) || (ssEntity = entityWithExtInfo.getReferredEntity((ssObjId = (AtlasObjectId)o).getGuid())) == null || ssEntity.getStatus() != AtlasEntity.Status.ACTIVE) continue;
                AtlasUserSavedSearch savedSearch = this.savedSearchDTO.from(ssEntity);
                userProfile.getSavedSearches().add(savedSearch);
            }
        }
        return userProfile;
    }

    @Override
    public AtlasEntity toEntity(AtlasUserProfile obj) throws AtlasBaseException {
        AtlasEntity entity = this.getDefaultAtlasEntity(obj);
        entity.setAttribute(PROPERTY_USER_NAME, (Object)obj.getName());
        entity.setAttribute(PROPERTY_FULL_NAME, (Object)obj.getFullName());
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasUserProfile obj) throws AtlasBaseException {
        AtlasEntity entity = this.toEntity(obj);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo(entity);
        AtlasObjectId userProfileId = new AtlasObjectId(entity.getGuid(), ENTITY_TYPE_NAME, Collections.singletonMap(PROPERTY_USER_NAME, obj.getName()));
        ArrayList<AtlasObjectId> objectIds = new ArrayList<AtlasObjectId>();
        for (AtlasUserSavedSearch ss : obj.getSavedSearches()) {
            AtlasEntity ssEntity = this.savedSearchDTO.toEntity(ss);
            ssEntity.setAttribute("userProfile", (Object)userProfileId);
            entityWithExtInfo.addReferredEntity(ssEntity);
            objectIds.add(new AtlasObjectId(ssEntity.getGuid(), this.savedSearchDTO.getEntityType().getTypeName(), this.savedSearchDTO.getUniqueAttributes(ss)));
        }
        if (objectIds.size() > 0) {
            entity.setAttribute(PROPERTY_SAVED_SEARCHES, objectIds);
        }
        return entityWithExtInfo;
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasUserProfile obj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(PROPERTY_USER_NAME, obj.getName());
        return ret;
    }
}

