/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.listener.ActiveStateChangeHandler;
import org.apache.atlas.repository.patches.AtlasPatchManager;
import org.apache.atlas.service.Service;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class AtlasPatchService
implements Service,
ActiveStateChangeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPatchService.class);
    private final Configuration configuration;
    private final AtlasPatchManager patchManager;

    @Inject
    public AtlasPatchService(Configuration configuration, AtlasPatchManager patchManager) {
        this.configuration = configuration;
        this.patchManager = patchManager;
    }

    public void start() throws AtlasException {
        LOG.info("==> AtlasPatchService.start()");
        if (!HAConfiguration.isHAEnabled((Configuration)this.configuration)) {
            this.startInternal();
        } else {
            LOG.info("AtlasPatchService.start(): deferring patches until instance activation");
        }
        LOG.info("<== AtlasPatchService.start()");
    }

    public void stop() {
        LOG.info("AtlasPatchService.stop(): stopped");
    }

    public void instanceIsActive() {
        LOG.info("==> AtlasPatchService.instanceIsActive()");
        this.startInternal();
        LOG.info("<== AtlasPatchService.instanceIsActive()");
    }

    public void instanceIsPassive() {
        LOG.info("AtlasPatchService.instanceIsPassive(): no action needed");
    }

    public int getHandlerOrder() {
        return ActiveStateChangeHandler.HandlerOrder.ATLAS_PATCH_SERVICE.getOrder();
    }

    void startInternal() {
        try {
            LOG.info("AtlasPatchService: applying patches...");
            this.patchManager.applyAll();
        }
        catch (Exception ex) {
            LOG.error("AtlasPatchService: failed in applying patches", (Throwable)ex);
        }
    }
}

