/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.PatchContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexConsistencyPatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IndexConsistencyPatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_005";
    private static final String PATCH_DESCRIPTION = "Sets index consistency for vertices and edges.";
    private final PatchContext context;

    public IndexConsistencyPatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        if (!AtlasConfiguration.STORAGE_CONSISTENCY_LOCK_ENABLED.getBoolean()) {
            LOG.info("IndexConsistencyPatch: Not enabled: Skipped!");
            return;
        }
        AtlasGraph graph = this.context.getGraph();
        try {
            LOG.info("IndexConsistencyPatch: Starting...");
            graph.getManagementSystem().updateUniqueIndexesForConsistencyLock();
        }
        finally {
            LOG.info("IndexConsistencyPatch: Done!");
        }
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("IndexConsistencyPatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }
}

