/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasAbstractDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasStructDefStoreV2;
import org.apache.atlas.repository.store.graph.v2.AtlasTypeDefGraphStoreV2;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasBusinessMetadataDefStoreV2
extends AtlasAbstractDefStoreV2<AtlasBusinessMetadataDef> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasBusinessMetadataDefStoreV2.class);
    private final EntityDiscoveryService entityDiscoveryService;

    @Inject
    public AtlasBusinessMetadataDefStoreV2(AtlasTypeDefGraphStoreV2 typeDefStore, AtlasTypeRegistry typeRegistry, EntityDiscoveryService entityDiscoveryService) {
        super(typeDefStore, typeRegistry);
        this.entityDiscoveryService = entityDiscoveryService;
    }

    @Override
    public AtlasVertex preCreate(AtlasBusinessMetadataDef businessMetadataDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.preCreate({})", (Object)businessMetadataDef);
        }
        this.validateType((AtlasBaseTypeDef)businessMetadataDef);
        AtlasType type = this.typeRegistry.getType(businessMetadataDef.getName());
        if (type.getTypeCategory() != TypeCategory.BUSINESS_METADATA) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{businessMetadataDef.getName(), DataTypes.TypeCategory.BUSINESS_METADATA.name()});
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_CREATE, (AtlasBaseTypeDef)businessMetadataDef), (Object[])new Object[]{"create businessMetadata-def ", businessMetadataDef.getName()});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByName(businessMetadataDef.getName());
        if (ret != null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_ALREADY_EXISTS, new String[]{businessMetadataDef.getName()});
        }
        ret = this.typeDefStore.createTypeVertex((AtlasBaseTypeDef)businessMetadataDef);
        this.updateVertexPreCreate(businessMetadataDef, (AtlasBusinessMetadataType)type, ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.preCreate({}): {}", (Object)businessMetadataDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public void validateType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
        super.validateType(typeDef);
        AtlasBusinessMetadataDef businessMetadataDef = (AtlasBusinessMetadataDef)typeDef;
        if (CollectionUtils.isNotEmpty((Collection)businessMetadataDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : businessMetadataDef.getAttributeDefs()) {
                if (this.isValidName(attributeDef.getName())) continue;
                throw new AtlasBaseException(AtlasErrorCode.ATTRIBUTE_NAME_INVALID_CHARS, new String[]{attributeDef.getName()});
            }
        }
    }

    @Override
    public AtlasBusinessMetadataDef create(AtlasBusinessMetadataDef businessMetadataDef, AtlasVertex preCreateResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.create({}, {})", (Object)businessMetadataDef, (Object)preCreateResult);
        }
        this.verifyAttributeTypeReadAccess((Collection)businessMetadataDef.getAttributeDefs());
        if (CollectionUtils.isNotEmpty((Collection)businessMetadataDef.getAttributeDefs())) {
            AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(businessMetadataDef.getName());
            for (AtlasStructType.AtlasAttribute attribute : businessMetadataType.getAllAttributes().values()) {
                AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute = (AtlasBusinessMetadataType.AtlasBusinessAttribute)attribute;
                this.verifyTypesReadAccess((Collection)bmAttribute.getApplicableEntityTypes());
            }
        }
        AtlasVertex vertex = preCreateResult == null ? this.preCreate(businessMetadataDef) : preCreateResult;
        AtlasBusinessMetadataDef ret = this.toBusinessMetadataDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.create({}, {}): {}", new Object[]{businessMetadataDef, preCreateResult, ret});
        }
        return ret;
    }

    @Override
    public List<AtlasBusinessMetadataDef> getAll() throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDef.getAll()");
        }
        ArrayList<AtlasBusinessMetadataDef> ret = new ArrayList<AtlasBusinessMetadataDef>();
        Iterator<AtlasVertex> vertices = this.typeDefStore.findTypeVerticesByCategory(DataTypes.TypeCategory.BUSINESS_METADATA);
        while (vertices.hasNext()) {
            ret.add(this.toBusinessMetadataDef(vertices.next()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.getAll(): count={}", (Object)ret.size());
        }
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef getByName(String name) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.getByName({})", (Object)name);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.BUSINESS_METADATA)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        vertex.getProperty(Constants.TYPE_CATEGORY_PROPERTY_KEY, String.class);
        AtlasBusinessMetadataDef ret = this.toBusinessMetadataDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.getByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef getByGuid(String guid) throws AtlasBaseException {
        AtlasVertex vertex;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.getByGuid({})", (Object)guid);
        }
        if ((vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.BUSINESS_METADATA)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        AtlasBusinessMetadataDef ret = this.toBusinessMetadataDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.getByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef update(AtlasBusinessMetadataDef typeDef) throws AtlasBaseException {
        AtlasBusinessMetadataDef ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.update({})", (Object)typeDef);
        }
        this.verifyAttributeTypeReadAccess((Collection)typeDef.getAttributeDefs());
        if (CollectionUtils.isNotEmpty((Collection)typeDef.getAttributeDefs())) {
            AtlasBusinessMetadataType businessMetadataType = this.typeRegistry.getBusinessMetadataTypeByName(typeDef.getName());
            for (AtlasStructType.AtlasAttribute attribute : businessMetadataType.getAllAttributes().values()) {
                AtlasBusinessMetadataType.AtlasBusinessAttribute bmAttribute = (AtlasBusinessMetadataType.AtlasBusinessAttribute)attribute;
                this.verifyTypesReadAccess((Collection)bmAttribute.getApplicableEntityTypes());
            }
        }
        this.validateType((AtlasBaseTypeDef)typeDef);
        AtlasBusinessMetadataDef atlasBusinessMetadataDef = ret = StringUtils.isNotBlank((String)typeDef.getGuid()) ? this.updateByGuid(typeDef.getGuid(), typeDef) : this.updateByName(typeDef.getName(), typeDef);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.update({}): {}", (Object)typeDef, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef updateByName(String name, AtlasBusinessMetadataDef typeDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.updateByName({}, {})", (Object)name, (Object)typeDef);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update businessMetadata-def ", name});
        this.validateType((AtlasBaseTypeDef)typeDef);
        AtlasType type = this.typeRegistry.getType(typeDef.getName());
        if (type.getTypeCategory() != TypeCategory.BUSINESS_METADATA) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{typeDef.getName(), DataTypes.TypeCategory.BUSINESS_METADATA.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.updateVertexPreUpdate(typeDef, (AtlasBusinessMetadataType)type, vertex);
        AtlasBusinessMetadataDef ret = this.toBusinessMetadataDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.updateByName({}, {}): {}", new Object[]{name, typeDef, ret});
        }
        return ret;
    }

    @Override
    public AtlasBusinessMetadataDef updateByGuid(String guid, AtlasBusinessMetadataDef typeDef) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.updateByGuid({})", (Object)guid);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_UPDATE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"update businessMetadata-def ", existingDef != null ? existingDef.getName() : guid});
        this.validateType((AtlasBaseTypeDef)typeDef);
        AtlasType type = this.typeRegistry.getTypeByGuid(guid);
        if (type.getTypeCategory() != TypeCategory.BUSINESS_METADATA) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_MATCH_FAILED, new String[]{typeDef.getName(), DataTypes.TypeCategory.BUSINESS_METADATA.name()});
        }
        AtlasVertex vertex = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (vertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.updateVertexPreUpdate(typeDef, (AtlasBusinessMetadataType)type, vertex);
        AtlasBusinessMetadataDef ret = this.toBusinessMetadataDef(vertex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.updateByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByName(String name) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.preDeleteByName({})", (Object)name);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByName(name);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete businessMetadata-def ", name});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByNameAndCategory(name, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{name});
        }
        this.checkBusinessMetadataRef(existingDef.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.preDeleteByName({}): {}", (Object)name, (Object)ret);
        }
        return ret;
    }

    @Override
    public AtlasVertex preDeleteByGuid(String guid) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasBusinessMetadataDefStoreV2.preDeleteByGuid({})", (Object)guid);
        }
        AtlasBusinessMetadataDef existingDef = this.typeRegistry.getBusinessMetadataDefByGuid(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasTypeAccessRequest)new AtlasTypeAccessRequest(AtlasPrivilege.TYPE_DELETE, (AtlasBaseTypeDef)existingDef), (Object[])new Object[]{"delete businessMetadata-def ", existingDef != null ? existingDef.getName() : guid});
        AtlasVertex ret = this.typeDefStore.findTypeVertexByGuidAndCategory(guid, DataTypes.TypeCategory.BUSINESS_METADATA);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, new String[]{guid});
        }
        this.checkBusinessMetadataRef(existingDef.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasBusinessMetadataDefStoreV2.preDeleteByGuid({}): ret={}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    private void updateVertexPreCreate(AtlasBusinessMetadataDef businessMetadataDef, AtlasBusinessMetadataType businessMetadataType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasStructDefStoreV2.updateVertexPreCreate((AtlasStructDef)businessMetadataDef, (AtlasStructType)businessMetadataType, vertex, this.typeDefStore);
    }

    private void updateVertexPreUpdate(AtlasBusinessMetadataDef businessMetadataDef, AtlasBusinessMetadataType businessMetadataType, AtlasVertex vertex) throws AtlasBaseException {
        AtlasBusinessMetadataDef currentBusinessMetadataDef = this.toBusinessMetadataDef(vertex);
        if (CollectionUtils.isNotEmpty((Collection)businessMetadataDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : businessMetadataDef.getAttributeDefs()) {
                String existingApplicableEntityTypesString;
                Set existingApplicableEntityTypes;
                Set updatedApplicableEntityTypes;
                String updatedApplicableEntityTypesString = attributeDef.getOption("applicableEntityTypes");
                Set set = updatedApplicableEntityTypes = StringUtils.isBlank((String)updatedApplicableEntityTypesString) ? null : (Set)AtlasType.fromJson((String)updatedApplicableEntityTypesString, Set.class);
                AtlasStructDef.AtlasAttributeDef existingAttribute = currentBusinessMetadataDef.getAttribute(attributeDef.getName());
                if (existingAttribute == null || (existingApplicableEntityTypes = StringUtils.isBlank((String)(existingApplicableEntityTypesString = existingAttribute.getOption("applicableEntityTypes"))) ? null : (Set)AtlasType.fromJson((String)existingApplicableEntityTypesString, Set.class)) == null || updatedApplicableEntityTypes.containsAll(existingApplicableEntityTypes)) continue;
                throw new AtlasBaseException(AtlasErrorCode.APPLICABLE_ENTITY_TYPES_DELETION_NOT_SUPPORTED, new String[]{attributeDef.getName(), businessMetadataDef.getName()});
            }
        }
        AtlasStructDefStoreV2.updateVertexPreUpdate((AtlasStructDef)businessMetadataDef, (AtlasStructType)businessMetadataType, vertex, this.typeDefStore);
    }

    private AtlasBusinessMetadataDef toBusinessMetadataDef(AtlasVertex vertex) throws AtlasBaseException {
        AtlasBusinessMetadataDef ret = null;
        if (vertex != null && this.typeDefStore.isTypeVertex(vertex, DataTypes.TypeCategory.BUSINESS_METADATA)) {
            ret = new AtlasBusinessMetadataDef();
            AtlasStructDefStoreV2.toStructDef(vertex, (AtlasStructDef)ret, this.typeDefStore);
        }
        return ret;
    }

    private void checkBusinessMetadataRef(String typeName) throws AtlasBaseException {
        AtlasBusinessMetadataDef businessMetadataDef = this.typeRegistry.getBusinessMetadataDefByName(typeName);
        if (businessMetadataDef != null) {
            List attributeDefs = businessMetadataDef.getAttributeDefs();
            for (AtlasStructDef.AtlasAttributeDef attributeDef : attributeDefs) {
                Set applicableTypes;
                String qualifiedName;
                String vertexPropertyName = AtlasStructType.AtlasAttribute.generateVertexPropertyName((AtlasStructDef)businessMetadataDef, (AtlasStructDef.AtlasAttributeDef)attributeDef, (String)(qualifiedName = AtlasStructType.AtlasAttribute.getQualifiedAttributeName((AtlasStructDef)businessMetadataDef, (String)attributeDef.getName())));
                if (!this.isBusinessAttributePresent(vertexPropertyName, applicableTypes = (Set)AtlasJson.fromJson((String)attributeDef.getOption("applicableEntityTypes"), Set.class))) continue;
                throw new AtlasBaseException(AtlasErrorCode.TYPE_HAS_REFERENCES, new String[]{typeName});
            }
        }
    }

    private boolean isBusinessAttributePresent(String attrName, Set<String> applicableTypes) throws AtlasBaseException {
        SearchParameters.FilterCriteria criteria = new SearchParameters.FilterCriteria();
        criteria.setAttributeName(attrName);
        criteria.setOperator(SearchParameters.Operator.NOT_EMPTY);
        SearchParameters.FilterCriteria entityFilters = new SearchParameters.FilterCriteria();
        entityFilters.setCondition(SearchParameters.FilterCriteria.Condition.OR);
        entityFilters.setCriterion(Collections.singletonList(criteria));
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setTypeName(String.join((CharSequence)",", applicableTypes));
        searchParameters.setExcludeDeletedEntities(true);
        searchParameters.setIncludeSubClassifications(false);
        searchParameters.setEntityFilters(entityFilters);
        searchParameters.setAttributes(Collections.singleton(attrName));
        searchParameters.setOffset(0);
        searchParameters.setLimit(1);
        AtlasSearchResult atlasSearchResult = this.entityDiscoveryService.searchWithParameters(searchParameters);
        return CollectionUtils.isNotEmpty((Collection)atlasSearchResult.getEntities());
    }
}

