/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasCheckStateRequest;
import org.apache.atlas.model.instance.AtlasCheckStateResult;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.AtlasGraphProvider;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class EntityStateChecker {
    private static final Logger LOG = LoggerFactory.getLogger(EntityStateChecker.class);
    private final AtlasGraph graph;
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityRetriever;

    @Inject
    public EntityStateChecker(AtlasGraph graph, AtlasTypeRegistry typeRegistry) {
        this.graph = graph;
        this.typeRegistry = typeRegistry;
        this.entityRetriever = new EntityGraphRetriever(graph, typeRegistry);
    }

    public AtlasCheckStateResult checkState(AtlasCheckStateRequest request) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> checkState({})", (Object)request);
        }
        AtlasCheckStateResult ret = new AtlasCheckStateResult();
        if (request != null) {
            if (CollectionUtils.isNotEmpty((Collection)request.getEntityGuids())) {
                for (Object guid : request.getEntityGuids()) {
                    this.checkEntityState((String)guid, request.getFixIssues(), ret);
                }
            } else if (CollectionUtils.isNotEmpty((Collection)request.getEntityTypes())) {
                Collection entityTypes = request.getEntityTypes().contains("*") ? this.typeRegistry.getAllEntityDefNames() : request.getEntityTypes();
                LOG.info("checkState(): scanning for entities of {} types", (Object)entityTypes.size());
                for (String typeName : entityTypes) {
                    AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                    if (entityType == null) {
                        LOG.warn("checkState(): {} - entity-type not found", (Object)typeName);
                        continue;
                    }
                    LOG.info("checkState(): scanning for {} entities", (Object)typeName);
                    AtlasGraphQuery query = AtlasGraphProvider.getGraphInstance().query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)typeName);
                    int count = 0;
                    Iterator iter = query.vertices().iterator();
                    while (iter.hasNext()) {
                        this.checkEntityState((AtlasVertex)iter.next(), request.getFixIssues(), ret);
                        ++count;
                    }
                    LOG.info("checkState(): scanned {} {} entities", (Object)count, (Object)typeName);
                }
            }
            int incorrectFixed = ret.getEntitiesFixed();
            int incorrectPartiallyFixed = ret.getEntitiesPartiallyFixed();
            int incorrectNotFixed = ret.getEntitiesNotFixed();
            if (incorrectFixed == 0 && incorrectPartiallyFixed == 0 && incorrectNotFixed == 0) {
                ret.setState(AtlasCheckStateResult.State.OK);
            } else if (incorrectPartiallyFixed != 0) {
                ret.setState(AtlasCheckStateResult.State.PARTIALLY_FIXED);
            } else if (incorrectNotFixed != 0) {
                ret.setState(incorrectFixed > 0 ? AtlasCheckStateResult.State.PARTIALLY_FIXED : AtlasCheckStateResult.State.NOT_FIXED);
            } else {
                ret.setState(AtlasCheckStateResult.State.FIXED);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== checkState({}, {})", (Object)request, (Object)ret);
        }
        return ret;
    }

    public AtlasCheckStateResult.AtlasEntityState checkEntityState(String guid, boolean fixIssues, AtlasCheckStateResult result) throws AtlasBaseException {
        AtlasVertex entityVertex = AtlasGraphUtilsV2.findByGuid(this.graph, guid);
        if (entityVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_GUID_NOT_FOUND, new String[]{guid});
        }
        return this.checkEntityState(entityVertex, fixIssues, result);
    }

    public AtlasCheckStateResult.AtlasEntityState checkEntityState(AtlasVertex entityVertex, boolean fixIssues, AtlasCheckStateResult result) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> checkEntityState(guid={})", (Object)AtlasGraphUtilsV2.getIdFromVertex(entityVertex));
        }
        AtlasCheckStateResult.AtlasEntityState ret = new AtlasCheckStateResult.AtlasEntityState();
        ret.setGuid(AtlasGraphUtilsV2.getIdFromVertex(entityVertex));
        ret.setTypeName(AtlasGraphUtilsV2.getTypeName((AtlasElement)entityVertex));
        ret.setName(this.getEntityName(entityVertex));
        ret.setStatus(AtlasGraphUtilsV2.getState((AtlasElement)entityVertex));
        ret.setState(AtlasCheckStateResult.State.OK);
        this.checkEntityState_Classifications(entityVertex, ret, fixIssues);
        if (ret.getState() != AtlasCheckStateResult.State.OK) {
            if (result.getEntities() == null) {
                result.setEntities(new HashMap());
            }
            result.getEntities().put(ret.getGuid(), ret);
        }
        result.incrEntitiesScanned();
        switch (ret.getState()) {
            case FIXED: {
                result.incrEntitiesFixed();
                break;
            }
            case PARTIALLY_FIXED: {
                result.incrEntitiesPartiallyFixed();
                break;
            }
            case NOT_FIXED: {
                result.incrEntitiesNotFixed();
                break;
            }
            case OK: {
                result.incrEntitiesOk();
            }
        }
        LOG.info("checkEntityState(guid={}; type={}; name={}): {}", new Object[]{ret.getGuid(), ret.getTypeName(), ret.getName(), ret.getState()});
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== checkEntityState({}): {}", (Object)ret.getGuid(), (Object)ret);
        }
        return ret;
    }

    private void checkEntityState_Classifications(AtlasVertex entityVertex, AtlasCheckStateResult.AtlasEntityState result, boolean fixIssues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> checkEntityState_Classifications({}, {})", (Object)result, (Object)fixIssues);
        }
        Collection traitNames = entityVertex.getPropertyValues(Constants.TRAIT_NAMES_PROPERTY_KEY, String.class);
        Collection propagatedTraitNames = entityVertex.getPropertyValues(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, String.class);
        Collection<String> traitVertexNames = null;
        Collection<String> propagatedTraitVertexNames = null;
        Iterable edges = entityVertex.getEdges(AtlasEdgeDirection.OUT, "classifiedAs");
        if (edges != null) {
            for (AtlasEdge edge : edges) {
                Boolean isPropagated = AtlasGraphUtilsV2.getEncodedProperty(edge, Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY, Boolean.class);
                String classificationName = GraphHelper.getTypeName((AtlasElement)edge.getInVertex());
                AtlasClassificationType classification = this.typeRegistry.getClassificationTypeByName(classificationName);
                if (classification == null) continue;
                if (isPropagated != null && isPropagated.booleanValue()) {
                    propagatedTraitVertexNames = this.addToCollection(propagatedTraitVertexNames, classificationName);
                    continue;
                }
                traitVertexNames = this.addToCollection(traitVertexNames, classificationName);
            }
            if (traitVertexNames == null) {
                traitVertexNames = Collections.emptyList();
            }
            if (propagatedTraitVertexNames == null) {
                propagatedTraitVertexNames = Collections.emptyList();
            }
        }
        Collection<String> traitNamesToAdd = this.subtract(traitVertexNames, traitNames);
        Collection<String> traitNamesToRemove = this.subtract(traitNames, traitVertexNames);
        Collection<String> propagatedTraitNamesToAdd = this.subtract(propagatedTraitVertexNames, propagatedTraitNames);
        Collection<String> propagatedTraitNamesToRemove = this.subtract(propagatedTraitNames, propagatedTraitVertexNames);
        if (traitNamesToAdd != null || traitNamesToRemove != null || propagatedTraitNamesToAdd != null || propagatedTraitNamesToRemove != null) {
            ArrayList<String> issues = result.getIssues();
            if (issues == null) {
                issues = new ArrayList<String>();
                result.setIssues(issues);
            }
            if (fixIssues) {
                if (traitNamesToAdd != null || traitNamesToRemove != null) {
                    if (traitNamesToAdd != null) {
                        issues.add("incorrect property: __traitNames has missing classifications: " + traitNamesToAdd.toString());
                    }
                    if (traitNamesToRemove != null) {
                        issues.add("incorrect property: __traitNames has unassigned classifications: " + traitNamesToRemove.toString());
                    }
                    entityVertex.removeProperty(Constants.TRAIT_NAMES_PROPERTY_KEY);
                    entityVertex.removeProperty(Constants.CLASSIFICATION_NAMES_KEY);
                    for (String classificationName : traitVertexNames) {
                        AtlasGraphUtilsV2.addEncodedProperty(entityVertex, Constants.TRAIT_NAMES_PROPERTY_KEY, (Object)classificationName);
                    }
                    entityVertex.setProperty(Constants.CLASSIFICATION_NAMES_KEY, (Object)GraphHelper.getDelimitedClassificationNames(traitVertexNames));
                }
                if (propagatedTraitNamesToAdd != null || propagatedTraitNamesToRemove != null) {
                    if (propagatedTraitNamesToAdd != null) {
                        issues.add("incorrect property: __propagatedTraitNames has missing classifications: " + propagatedTraitNamesToAdd.toString());
                    }
                    if (propagatedTraitNamesToRemove != null) {
                        issues.add("incorrect property: __propagatedTraitNames has unassigned classifications: " + propagatedTraitNamesToRemove.toString());
                    }
                    entityVertex.removeProperty(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY);
                    entityVertex.removeProperty(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY);
                    for (String classificationName : propagatedTraitVertexNames) {
                        AtlasGraphUtilsV2.addEncodedProperty(entityVertex, Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (Object)classificationName);
                    }
                    entityVertex.setProperty(Constants.PROPAGATED_CLASSIFICATION_NAMES_KEY, (Object)GraphHelper.getDelimitedClassificationNames(propagatedTraitVertexNames));
                }
                AtlasGraphUtilsV2.setEncodedProperty(entityVertex, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, RequestContext.get().getRequestTime());
                result.setState(AtlasCheckStateResult.State.FIXED);
            } else {
                result.setState(AtlasCheckStateResult.State.NOT_FIXED);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== checkEntityState_Classifications({}, {})", (Object)result, (Object)fixIssues);
        }
    }

    private String getEntityName(AtlasVertex entityVertex) throws AtlasBaseException {
        String ret = null;
        Map<String, Object> uniqueAttributes = this.entityRetriever.getEntityUniqueAttribute(entityVertex);
        if (uniqueAttributes != null) {
            Object val = uniqueAttributes.get("qualifiedName");
            if (val == null) {
                for (Object attrVal : uniqueAttributes.values()) {
                    if (attrVal == null) continue;
                    ret = attrVal.toString();
                    break;
                }
            } else {
                ret = val.toString();
            }
        }
        return ret;
    }

    private Collection<String> addToCollection(Collection<String> list, String str) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(str);
        return list;
    }

    private Collection<String> subtract(Collection<String> col1, Collection<String> col2) {
        Collection<String> ret = null;
        if (col2 == null) {
            ret = col1;
        } else if (col1 != null) {
            for (String elem : col1) {
                if (col2.contains(elem)) continue;
                if (ret == null) {
                    ret = new ArrayList<String>();
                }
                ret.add(elem);
            }
        }
        return ret;
    }
}

